<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemStatus StructType
 * @subpackage Structs
 */
class ItemStatus extends AbstractStructBase
{
    /**
     * The Ended
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Ended;
    /**
     * The GotBidders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GotBidders;
    /**
     * The GotWinner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GotWinner;
    /**
     * Constructor method for ItemStatus
     * @uses ItemStatus::setEnded()
     * @uses ItemStatus::setGotBidders()
     * @uses ItemStatus::setGotWinner()
     * @param bool $ended
     * @param bool $gotBidders
     * @param bool $gotWinner
     */
    public function __construct($ended = null, $gotBidders = null, $gotWinner = null)
    {
        $this
            ->setEnded($ended)
            ->setGotBidders($gotBidders)
            ->setGotWinner($gotWinner);
    }
    /**
     * Get Ended value
     * @return bool
     */
    public function getEnded()
    {
        return $this->Ended;
    }
    /**
     * Set Ended value
     * @param bool $ended
     * @return \StructType\ItemStatus
     */
    public function setEnded($ended = null)
    {
        // validation for constraint: boolean
        if (!is_null($ended) && !is_bool($ended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ended, true), gettype($ended)), __LINE__);
        }
        $this->Ended = $ended;
        return $this;
    }
    /**
     * Get GotBidders value
     * @return bool
     */
    public function getGotBidders()
    {
        return $this->GotBidders;
    }
    /**
     * Set GotBidders value
     * @param bool $gotBidders
     * @return \StructType\ItemStatus
     */
    public function setGotBidders($gotBidders = null)
    {
        // validation for constraint: boolean
        if (!is_null($gotBidders) && !is_bool($gotBidders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gotBidders, true), gettype($gotBidders)), __LINE__);
        }
        $this->GotBidders = $gotBidders;
        return $this;
    }
    /**
     * Get GotWinner value
     * @return bool
     */
    public function getGotWinner()
    {
        return $this->GotWinner;
    }
    /**
     * Set GotWinner value
     * @param bool $gotWinner
     * @return \StructType\ItemStatus
     */
    public function setGotWinner($gotWinner = null)
    {
        // validation for constraint: boolean
        if (!is_null($gotWinner) && !is_bool($gotWinner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gotWinner, true), gettype($gotWinner)), __LINE__);
        }
        $this->GotWinner = $gotWinner;
        return $this;
    }
}
