<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemImageData StructType
 * @subpackage Structs
 */
class ItemImageData extends AbstractStructBase
{
    /**
     * The HasMega
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasMega;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Format;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for ItemImageData
     * @uses ItemImageData::setHasMega()
     * @uses ItemImageData::setFormat()
     * @uses ItemImageData::setData()
     * @uses ItemImageData::setName()
     * @param bool $hasMega
     * @param string $format
     * @param string $data
     * @param string $name
     */
    public function __construct($hasMega = null, $format = null, $data = null, $name = null)
    {
        $this
            ->setHasMega($hasMega)
            ->setFormat($format)
            ->setData($data)
            ->setName($name);
    }
    /**
     * Get HasMega value
     * @return bool
     */
    public function getHasMega()
    {
        return $this->HasMega;
    }
    /**
     * Set HasMega value
     * @param bool $hasMega
     * @return \StructType\ItemImageData
     */
    public function setHasMega($hasMega = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMega) && !is_bool($hasMega)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMega, true), gettype($hasMega)), __LINE__);
        }
        $this->HasMega = $hasMega;
        return $this;
    }
    /**
     * Get Format value
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @uses \EnumType\ImageFormat::valueIsValid()
     * @uses \EnumType\ImageFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \StructType\ItemImageData
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImageFormat::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImageFormat', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \EnumType\ImageFormat::getValidValues())), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \StructType\ItemImageData
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ItemImageData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
