<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSellerTransactionsRequest StructType
 * @subpackage Structs
 */
class GetSellerTransactionsRequest extends AbstractStructBase
{
    /**
     * The MinTransactionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MinTransactionDate;
    /**
     * The MaxTransactionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaxTransactionDate;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Filter;
    /**
     * Constructor method for GetSellerTransactionsRequest
     * @uses GetSellerTransactionsRequest::setMinTransactionDate()
     * @uses GetSellerTransactionsRequest::setMaxTransactionDate()
     * @uses GetSellerTransactionsRequest::setFilter()
     * @param string $minTransactionDate
     * @param string $maxTransactionDate
     * @param string $filter
     */
    public function __construct($minTransactionDate = null, $maxTransactionDate = null, $filter = null)
    {
        $this
            ->setMinTransactionDate($minTransactionDate)
            ->setMaxTransactionDate($maxTransactionDate)
            ->setFilter($filter);
    }
    /**
     * Get MinTransactionDate value
     * @return string
     */
    public function getMinTransactionDate()
    {
        return $this->MinTransactionDate;
    }
    /**
     * Set MinTransactionDate value
     * @param string $minTransactionDate
     * @return \StructType\GetSellerTransactionsRequest
     */
    public function setMinTransactionDate($minTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($minTransactionDate) && !is_string($minTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minTransactionDate, true), gettype($minTransactionDate)), __LINE__);
        }
        $this->MinTransactionDate = $minTransactionDate;
        return $this;
    }
    /**
     * Get MaxTransactionDate value
     * @return string
     */
    public function getMaxTransactionDate()
    {
        return $this->MaxTransactionDate;
    }
    /**
     * Set MaxTransactionDate value
     * @param string $maxTransactionDate
     * @return \StructType\GetSellerTransactionsRequest
     */
    public function setMaxTransactionDate($maxTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxTransactionDate) && !is_string($maxTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxTransactionDate, true), gettype($maxTransactionDate)), __LINE__);
        }
        $this->MaxTransactionDate = $maxTransactionDate;
        return $this;
    }
    /**
     * Get Filter value
     * @return string
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @uses \EnumType\TransactionFilter::valueIsValid()
     * @uses \EnumType\TransactionFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $filter
     * @return \StructType\GetSellerTransactionsRequest
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionFilter::valueIsValid($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionFilter', is_array($filter) ? implode(', ', $filter) : var_export($filter, true), implode(', ', \EnumType\TransactionFilter::getValidValues())), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
}
