<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticationHeader $authenticationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationHeader(\StructType\AuthenticationHeader $authenticationHeader, $nameSpace = 'http://api.tradera.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationHeader', $authenticationHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the AuthorizationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthorizationHeader $authorizationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthorizationHeader(\StructType\AuthorizationHeader $authorizationHeader, $nameSpace = 'http://api.tradera.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthorizationHeader', $authorizationHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the ConfigurationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ConfigurationHeader $configurationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderConfigurationHeader(\StructType\ConfigurationHeader $configurationHeader, $nameSpace = 'http://api.tradera.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ConfigurationHeader', $configurationHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItem $parameters
     * @return \StructType\GetItemResponse|bool
     */
    public function GetItem(\StructType\GetItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellerItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSellerItems $parameters
     * @return \StructType\GetSellerItemsResponse|bool
     */
    public function GetSellerItems(\StructType\GetSellerItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellerItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSellerTransactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSellerTransactions $parameters
     * @return \StructType\GetSellerTransactionsResponse|bool
     */
    public function GetSellerTransactions(\StructType\GetSellerTransactions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSellerTransactions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRequestResults
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRequestResults $parameters
     * @return \StructType\GetRequestResultsResponse|bool
     */
    public function GetRequestResults(\StructType\GetRequestResults $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRequestResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShopSettings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShopSettings $parameters
     * @return \StructType\GetShopSettingsResponse|bool
     */
    public function GetShopSettings(\StructType\GetShopSettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShopSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUpdatedSellerItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUpdatedSellerItems $parameters
     * @return \StructType\GetUpdatedSellerItemsResponse|bool
     */
    public function GetUpdatedSellerItems(\StructType\GetUpdatedSellerItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUpdatedSellerItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserInfo $parameters
     * @return \StructType\GetUserInfoResponse|bool
     */
    public function GetUserInfo(\StructType\GetUserInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMemberPaymentOptions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMemberPaymentOptions $parameters
     * @return \StructType\GetMemberPaymentOptionsResponse|bool
     */
    public function GetMemberPaymentOptions(\StructType\GetMemberPaymentOptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMemberPaymentOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetItemResponse|\StructType\GetMemberPaymentOptionsResponse|\StructType\GetRequestResultsResponse|\StructType\GetSellerItemsResponse|\StructType\GetSellerTransactionsResponse|\StructType\GetShopSettingsResponse|\StructType\GetUpdatedSellerItemsResponse|\StructType\GetUserInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
