<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ItemType EnumType
 * @subpackage Enumerations
 */
class ItemType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Auction'
     * @return string 'Auction'
     */
    const VALUE_AUCTION = 'Auction';
    /**
     * Constant for value 'PureBuyItNow'
     * @return string 'PureBuyItNow'
     */
    const VALUE_PURE_BUY_IT_NOW = 'PureBuyItNow';
    /**
     * Constant for value 'ShopItem'
     * @return string 'ShopItem'
     */
    const VALUE_SHOP_ITEM = 'ShopItem';
    /**
     * Return allowed values
     * @uses self::VALUE_AUCTION
     * @uses self::VALUE_PURE_BUY_IT_NOW
     * @uses self::VALUE_SHOP_ITEM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUCTION,
            self::VALUE_PURE_BUY_IT_NOW,
            self::VALUE_SHOP_ITEM,
        );
    }
}
