<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VariantData StructType
 * @subpackage Structs
 */
class VariantData extends AbstractStructBase
{
    /**
     * The VariantGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VariantGroupId;
    /**
     * The VariantAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfVariantAttribute
     */
    public $VariantAttributes;
    /**
     * Constructor method for VariantData
     * @uses VariantData::setVariantGroupId()
     * @uses VariantData::setVariantAttributes()
     * @param string $variantGroupId
     * @param \ArrayType\ArrayOfVariantAttribute $variantAttributes
     */
    public function __construct($variantGroupId = null, \ArrayType\ArrayOfVariantAttribute $variantAttributes = null)
    {
        $this
            ->setVariantGroupId($variantGroupId)
            ->setVariantAttributes($variantAttributes);
    }
    /**
     * Get VariantGroupId value
     * @return string|null
     */
    public function getVariantGroupId()
    {
        return $this->VariantGroupId;
    }
    /**
     * Set VariantGroupId value
     * @param string $variantGroupId
     * @return \StructType\VariantData
     */
    public function setVariantGroupId($variantGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($variantGroupId) && !is_string($variantGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variantGroupId, true), gettype($variantGroupId)), __LINE__);
        }
        $this->VariantGroupId = $variantGroupId;
        return $this;
    }
    /**
     * Get VariantAttributes value
     * @return \ArrayType\ArrayOfVariantAttribute|null
     */
    public function getVariantAttributes()
    {
        return $this->VariantAttributes;
    }
    /**
     * Set VariantAttributes value
     * @param \ArrayType\ArrayOfVariantAttribute $variantAttributes
     * @return \StructType\VariantData
     */
    public function setVariantAttributes(\ArrayType\ArrayOfVariantAttribute $variantAttributes = null)
    {
        $this->VariantAttributes = $variantAttributes;
        return $this;
    }
}
