<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionStatusUpdateData StructType
 * @subpackage Structs
 */
class TransactionStatusUpdateData extends AbstractStructBase
{
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionId;
    /**
     * The MarkAsPaidConfirmed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MarkAsPaidConfirmed;
    /**
     * The MarkedAsShipped
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MarkedAsShipped;
    /**
     * The MarkShippingBooked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MarkShippingBooked;
    /**
     * Constructor method for TransactionStatusUpdateData
     * @uses TransactionStatusUpdateData::setTransactionId()
     * @uses TransactionStatusUpdateData::setMarkAsPaidConfirmed()
     * @uses TransactionStatusUpdateData::setMarkedAsShipped()
     * @uses TransactionStatusUpdateData::setMarkShippingBooked()
     * @param int $transactionId
     * @param bool $markAsPaidConfirmed
     * @param bool $markedAsShipped
     * @param bool $markShippingBooked
     */
    public function __construct($transactionId = null, $markAsPaidConfirmed = null, $markedAsShipped = null, $markShippingBooked = null)
    {
        $this
            ->setTransactionId($transactionId)
            ->setMarkAsPaidConfirmed($markAsPaidConfirmed)
            ->setMarkedAsShipped($markedAsShipped)
            ->setMarkShippingBooked($markShippingBooked);
    }
    /**
     * Get TransactionId value
     * @return int
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param int $transactionId
     * @return \StructType\TransactionStatusUpdateData
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get MarkAsPaidConfirmed value
     * @return bool
     */
    public function getMarkAsPaidConfirmed()
    {
        return $this->MarkAsPaidConfirmed;
    }
    /**
     * Set MarkAsPaidConfirmed value
     * @param bool $markAsPaidConfirmed
     * @return \StructType\TransactionStatusUpdateData
     */
    public function setMarkAsPaidConfirmed($markAsPaidConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($markAsPaidConfirmed) && !is_bool($markAsPaidConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($markAsPaidConfirmed, true), gettype($markAsPaidConfirmed)), __LINE__);
        }
        $this->MarkAsPaidConfirmed = $markAsPaidConfirmed;
        return $this;
    }
    /**
     * Get MarkedAsShipped value
     * @return bool
     */
    public function getMarkedAsShipped()
    {
        return $this->MarkedAsShipped;
    }
    /**
     * Set MarkedAsShipped value
     * @param bool $markedAsShipped
     * @return \StructType\TransactionStatusUpdateData
     */
    public function setMarkedAsShipped($markedAsShipped = null)
    {
        // validation for constraint: boolean
        if (!is_null($markedAsShipped) && !is_bool($markedAsShipped)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($markedAsShipped, true), gettype($markedAsShipped)), __LINE__);
        }
        $this->MarkedAsShipped = $markedAsShipped;
        return $this;
    }
    /**
     * Get MarkShippingBooked value
     * @return bool
     */
    public function getMarkShippingBooked()
    {
        return $this->MarkShippingBooked;
    }
    /**
     * Set MarkShippingBooked value
     * @param bool $markShippingBooked
     * @return \StructType\TransactionStatusUpdateData
     */
    public function setMarkShippingBooked($markShippingBooked = null)
    {
        // validation for constraint: boolean
        if (!is_null($markShippingBooked) && !is_bool($markShippingBooked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($markShippingBooked, true), gettype($markShippingBooked)), __LINE__);
        }
        $this->MarkShippingBooked = $markShippingBooked;
        return $this;
    }
}
