<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transaction StructType
 * @subpackage Structs
 */
class Transaction extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Amount;
    /**
     * The LastUpdatedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdatedDate;
    /**
     * The IsMarkedAsPaidConfirmed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMarkedAsPaidConfirmed;
    /**
     * The IsMarkedAsShipped
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMarkedAsShipped;
    /**
     * The IsShippingBooked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsShippingBooked;
    /**
     * The IsFeedbackLeftBySeller
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFeedbackLeftBySeller;
    /**
     * The IsFeedbackLeftByBuyer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFeedbackLeftByBuyer;
    /**
     * The Buyer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\User
     */
    public $Buyer;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransactionItem
     */
    public $Item;
    /**
     * Constructor method for Transaction
     * @uses Transaction::setId()
     * @uses Transaction::setDate()
     * @uses Transaction::setAmount()
     * @uses Transaction::setLastUpdatedDate()
     * @uses Transaction::setIsMarkedAsPaidConfirmed()
     * @uses Transaction::setIsMarkedAsShipped()
     * @uses Transaction::setIsShippingBooked()
     * @uses Transaction::setIsFeedbackLeftBySeller()
     * @uses Transaction::setIsFeedbackLeftByBuyer()
     * @uses Transaction::setBuyer()
     * @uses Transaction::setItem()
     * @param int $id
     * @param string $date
     * @param int $amount
     * @param string $lastUpdatedDate
     * @param bool $isMarkedAsPaidConfirmed
     * @param bool $isMarkedAsShipped
     * @param bool $isShippingBooked
     * @param bool $isFeedbackLeftBySeller
     * @param bool $isFeedbackLeftByBuyer
     * @param \StructType\User $buyer
     * @param \StructType\TransactionItem $item
     */
    public function __construct($id = null, $date = null, $amount = null, $lastUpdatedDate = null, $isMarkedAsPaidConfirmed = null, $isMarkedAsShipped = null, $isShippingBooked = null, $isFeedbackLeftBySeller = null, $isFeedbackLeftByBuyer = null, \StructType\User $buyer = null, \StructType\TransactionItem $item = null)
    {
        $this
            ->setId($id)
            ->setDate($date)
            ->setAmount($amount)
            ->setLastUpdatedDate($lastUpdatedDate)
            ->setIsMarkedAsPaidConfirmed($isMarkedAsPaidConfirmed)
            ->setIsMarkedAsShipped($isMarkedAsShipped)
            ->setIsShippingBooked($isShippingBooked)
            ->setIsFeedbackLeftBySeller($isFeedbackLeftBySeller)
            ->setIsFeedbackLeftByBuyer($isFeedbackLeftByBuyer)
            ->setBuyer($buyer)
            ->setItem($item);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Transaction
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Transaction
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\Transaction
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get LastUpdatedDate value
     * @return string
     */
    public function getLastUpdatedDate()
    {
        return $this->LastUpdatedDate;
    }
    /**
     * Set LastUpdatedDate value
     * @param string $lastUpdatedDate
     * @return \StructType\Transaction
     */
    public function setLastUpdatedDate($lastUpdatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdatedDate) && !is_string($lastUpdatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdatedDate, true), gettype($lastUpdatedDate)), __LINE__);
        }
        $this->LastUpdatedDate = $lastUpdatedDate;
        return $this;
    }
    /**
     * Get IsMarkedAsPaidConfirmed value
     * @return bool
     */
    public function getIsMarkedAsPaidConfirmed()
    {
        return $this->IsMarkedAsPaidConfirmed;
    }
    /**
     * Set IsMarkedAsPaidConfirmed value
     * @param bool $isMarkedAsPaidConfirmed
     * @return \StructType\Transaction
     */
    public function setIsMarkedAsPaidConfirmed($isMarkedAsPaidConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMarkedAsPaidConfirmed) && !is_bool($isMarkedAsPaidConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMarkedAsPaidConfirmed, true), gettype($isMarkedAsPaidConfirmed)), __LINE__);
        }
        $this->IsMarkedAsPaidConfirmed = $isMarkedAsPaidConfirmed;
        return $this;
    }
    /**
     * Get IsMarkedAsShipped value
     * @return bool
     */
    public function getIsMarkedAsShipped()
    {
        return $this->IsMarkedAsShipped;
    }
    /**
     * Set IsMarkedAsShipped value
     * @param bool $isMarkedAsShipped
     * @return \StructType\Transaction
     */
    public function setIsMarkedAsShipped($isMarkedAsShipped = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMarkedAsShipped) && !is_bool($isMarkedAsShipped)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMarkedAsShipped, true), gettype($isMarkedAsShipped)), __LINE__);
        }
        $this->IsMarkedAsShipped = $isMarkedAsShipped;
        return $this;
    }
    /**
     * Get IsShippingBooked value
     * @return bool
     */
    public function getIsShippingBooked()
    {
        return $this->IsShippingBooked;
    }
    /**
     * Set IsShippingBooked value
     * @param bool $isShippingBooked
     * @return \StructType\Transaction
     */
    public function setIsShippingBooked($isShippingBooked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShippingBooked) && !is_bool($isShippingBooked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShippingBooked, true), gettype($isShippingBooked)), __LINE__);
        }
        $this->IsShippingBooked = $isShippingBooked;
        return $this;
    }
    /**
     * Get IsFeedbackLeftBySeller value
     * @return bool
     */
    public function getIsFeedbackLeftBySeller()
    {
        return $this->IsFeedbackLeftBySeller;
    }
    /**
     * Set IsFeedbackLeftBySeller value
     * @param bool $isFeedbackLeftBySeller
     * @return \StructType\Transaction
     */
    public function setIsFeedbackLeftBySeller($isFeedbackLeftBySeller = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFeedbackLeftBySeller) && !is_bool($isFeedbackLeftBySeller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFeedbackLeftBySeller, true), gettype($isFeedbackLeftBySeller)), __LINE__);
        }
        $this->IsFeedbackLeftBySeller = $isFeedbackLeftBySeller;
        return $this;
    }
    /**
     * Get IsFeedbackLeftByBuyer value
     * @return bool
     */
    public function getIsFeedbackLeftByBuyer()
    {
        return $this->IsFeedbackLeftByBuyer;
    }
    /**
     * Set IsFeedbackLeftByBuyer value
     * @param bool $isFeedbackLeftByBuyer
     * @return \StructType\Transaction
     */
    public function setIsFeedbackLeftByBuyer($isFeedbackLeftByBuyer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFeedbackLeftByBuyer) && !is_bool($isFeedbackLeftByBuyer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFeedbackLeftByBuyer, true), gettype($isFeedbackLeftByBuyer)), __LINE__);
        }
        $this->IsFeedbackLeftByBuyer = $isFeedbackLeftByBuyer;
        return $this;
    }
    /**
     * Get Buyer value
     * @return \StructType\User|null
     */
    public function getBuyer()
    {
        return $this->Buyer;
    }
    /**
     * Set Buyer value
     * @param \StructType\User $buyer
     * @return \StructType\Transaction
     */
    public function setBuyer(\StructType\User $buyer = null)
    {
        $this->Buyer = $buyer;
        return $this;
    }
    /**
     * Get Item value
     * @return \StructType\TransactionItem|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \StructType\TransactionItem $item
     * @return \StructType\Transaction
     */
    public function setItem(\StructType\TransactionItem $item = null)
    {
        $this->Item = $item;
        return $this;
    }
}
