<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestResult StructType
 * @subpackage Structs
 */
class RequestResult extends AbstractStructBase
{
    /**
     * The RequestId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RequestId;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string[]
     */
    public $ResultCode;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for RequestResult
     * @uses RequestResult::setRequestId()
     * @uses RequestResult::setResultCode()
     * @uses RequestResult::setMessage()
     * @param int $requestId
     * @param string[] $resultCode
     * @param string $message
     */
    public function __construct($requestId = null, array $resultCode = array(), $message = null)
    {
        $this
            ->setRequestId($requestId)
            ->setResultCode($resultCode)
            ->setMessage($message);
    }
    /**
     * Get RequestId value
     * @return int
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param int $requestId
     * @return \StructType\RequestResult
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !(is_int($requestId) || ctype_digit($requestId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string[]
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * This method is responsible for validating the values passed to the setResultCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResultCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResultCodeForArrayConstraintsFromSetResultCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestResultResultCodeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ResultCode::valueIsValid($requestResultResultCodeItem)) {
                $invalidValues[] = is_object($requestResultResultCodeItem) ? get_class($requestResultResultCodeItem) : sprintf('%s(%s)', gettype($requestResultResultCodeItem), var_export($requestResultResultCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ResultCode', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ResultCode::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResultCode value
     * @uses \EnumType\ResultCode::valueIsValid()
     * @uses \EnumType\ResultCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $resultCode
     * @return \StructType\RequestResult
     */
    public function setResultCode(array $resultCode = array())
    {
        // validation for constraint: list
        if ('' !== ($resultCodeArrayErrorMessage = self::validateResultCodeForArrayConstraintsFromSetResultCode($resultCode))) {
            throw new \InvalidArgumentException($resultCodeArrayErrorMessage, __LINE__);
        }
        $this->ResultCode = is_array($resultCode) ? implode(' ', $resultCode) : null;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\RequestResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
