<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveShopItem StructType
 * @subpackage Structs
 */
class RemoveShopItem extends AbstractStructBase
{
    /**
     * The shopItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $shopItemId;
    /**
     * Constructor method for RemoveShopItem
     * @uses RemoveShopItem::setShopItemId()
     * @param int $shopItemId
     */
    public function __construct($shopItemId = null)
    {
        $this
            ->setShopItemId($shopItemId);
    }
    /**
     * Get shopItemId value
     * @return int
     */
    public function getShopItemId()
    {
        return $this->shopItemId;
    }
    /**
     * Set shopItemId value
     * @param int $shopItemId
     * @return \StructType\RemoveShopItem
     */
    public function setShopItemId($shopItemId = null)
    {
        // validation for constraint: int
        if (!is_null($shopItemId) && !(is_int($shopItemId) || ctype_digit($shopItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shopItemId, true), gettype($shopItemId)), __LINE__);
        }
        $this->shopItemId = $shopItemId;
        return $this;
    }
}
