<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NumberValues StructType
 * @subpackage Structs
 */
class NumberValues extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDecimal
     */
    public $Values;
    /**
     * Constructor method for NumberValues
     * @uses NumberValues::setId()
     * @uses NumberValues::setValues()
     * @param int $id
     * @param \ArrayType\ArrayOfDecimal $values
     */
    public function __construct($id = null, \ArrayType\ArrayOfDecimal $values = null)
    {
        $this
            ->setId($id)
            ->setValues($values);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\NumberValues
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Values value
     * @return \ArrayType\ArrayOfDecimal|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @param \ArrayType\ArrayOfDecimal $values
     * @return \StructType\NumberValues
     */
    public function setValues(\ArrayType\ArrayOfDecimal $values = null)
    {
        $this->Values = $values;
        return $this;
    }
}
