<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemRequest StructType
 * @subpackage Structs
 */
class ItemRequest extends AbstractStructBase
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategoryId;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The Restarts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Restarts;
    /**
     * The StartPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StartPrice;
    /**
     * The ReservePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReservePrice;
    /**
     * The BuyItNowPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BuyItNowPrice;
    /**
     * The AcceptedBidderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AcceptedBidderId;
    /**
     * The CustomEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CustomEndDate;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemType;
    /**
     * The AutoCommit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AutoCommit;
    /**
     * The VAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $VAT;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The OwnReferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $OwnReferences;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PaymentOptionIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $PaymentOptionIds;
    /**
     * The ShippingOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItemShipping
     */
    public $ShippingOptions;
    /**
     * The ExpoItemIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $ExpoItemIds;
    /**
     * The ItemAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $ItemAttributes;
    /**
     * The ShippingCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCondition;
    /**
     * The PaymentCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCondition;
    /**
     * The CampaignCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CampaignCode;
    /**
     * The AttributeValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ItemAttributeValues
     */
    public $AttributeValues;
    /**
     * Constructor method for ItemRequest
     * @uses ItemRequest::setCategoryId()
     * @uses ItemRequest::setDuration()
     * @uses ItemRequest::setRestarts()
     * @uses ItemRequest::setStartPrice()
     * @uses ItemRequest::setReservePrice()
     * @uses ItemRequest::setBuyItNowPrice()
     * @uses ItemRequest::setAcceptedBidderId()
     * @uses ItemRequest::setCustomEndDate()
     * @uses ItemRequest::setItemType()
     * @uses ItemRequest::setAutoCommit()
     * @uses ItemRequest::setVAT()
     * @uses ItemRequest::setTitle()
     * @uses ItemRequest::setOwnReferences()
     * @uses ItemRequest::setDescription()
     * @uses ItemRequest::setPaymentOptionIds()
     * @uses ItemRequest::setShippingOptions()
     * @uses ItemRequest::setExpoItemIds()
     * @uses ItemRequest::setItemAttributes()
     * @uses ItemRequest::setShippingCondition()
     * @uses ItemRequest::setPaymentCondition()
     * @uses ItemRequest::setCampaignCode()
     * @uses ItemRequest::setAttributeValues()
     * @param int $categoryId
     * @param int $duration
     * @param int $restarts
     * @param int $startPrice
     * @param int $reservePrice
     * @param int $buyItNowPrice
     * @param int $acceptedBidderId
     * @param string $customEndDate
     * @param int $itemType
     * @param bool $autoCommit
     * @param int $vAT
     * @param string $title
     * @param \ArrayType\ArrayOfString $ownReferences
     * @param string $description
     * @param \ArrayType\ArrayOfInt $paymentOptionIds
     * @param \ArrayType\ArrayOfItemShipping $shippingOptions
     * @param \ArrayType\ArrayOfInt $expoItemIds
     * @param \ArrayType\ArrayOfInt $itemAttributes
     * @param string $shippingCondition
     * @param string $paymentCondition
     * @param string $campaignCode
     * @param \StructType\ItemAttributeValues $attributeValues
     */
    public function __construct($categoryId = null, $duration = null, $restarts = null, $startPrice = null, $reservePrice = null, $buyItNowPrice = null, $acceptedBidderId = null, $customEndDate = null, $itemType = null, $autoCommit = null, $vAT = null, $title = null, \ArrayType\ArrayOfString $ownReferences = null, $description = null, \ArrayType\ArrayOfInt $paymentOptionIds = null, \ArrayType\ArrayOfItemShipping $shippingOptions = null, \ArrayType\ArrayOfInt $expoItemIds = null, \ArrayType\ArrayOfInt $itemAttributes = null, $shippingCondition = null, $paymentCondition = null, $campaignCode = null, \StructType\ItemAttributeValues $attributeValues = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setDuration($duration)
            ->setRestarts($restarts)
            ->setStartPrice($startPrice)
            ->setReservePrice($reservePrice)
            ->setBuyItNowPrice($buyItNowPrice)
            ->setAcceptedBidderId($acceptedBidderId)
            ->setCustomEndDate($customEndDate)
            ->setItemType($itemType)
            ->setAutoCommit($autoCommit)
            ->setVAT($vAT)
            ->setTitle($title)
            ->setOwnReferences($ownReferences)
            ->setDescription($description)
            ->setPaymentOptionIds($paymentOptionIds)
            ->setShippingOptions($shippingOptions)
            ->setExpoItemIds($expoItemIds)
            ->setItemAttributes($itemAttributes)
            ->setShippingCondition($shippingCondition)
            ->setPaymentCondition($paymentCondition)
            ->setCampaignCode($campaignCode)
            ->setAttributeValues($attributeValues);
    }
    /**
     * Get CategoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param int $categoryId
     * @return \StructType\ItemRequest
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\ItemRequest
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Restarts value
     * @return int
     */
    public function getRestarts()
    {
        return $this->Restarts;
    }
    /**
     * Set Restarts value
     * @param int $restarts
     * @return \StructType\ItemRequest
     */
    public function setRestarts($restarts = null)
    {
        // validation for constraint: int
        if (!is_null($restarts) && !(is_int($restarts) || ctype_digit($restarts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($restarts, true), gettype($restarts)), __LINE__);
        }
        $this->Restarts = $restarts;
        return $this;
    }
    /**
     * Get StartPrice value
     * @return int
     */
    public function getStartPrice()
    {
        return $this->StartPrice;
    }
    /**
     * Set StartPrice value
     * @param int $startPrice
     * @return \StructType\ItemRequest
     */
    public function setStartPrice($startPrice = null)
    {
        // validation for constraint: int
        if (!is_null($startPrice) && !(is_int($startPrice) || ctype_digit($startPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startPrice, true), gettype($startPrice)), __LINE__);
        }
        $this->StartPrice = $startPrice;
        return $this;
    }
    /**
     * Get ReservePrice value
     * @return int
     */
    public function getReservePrice()
    {
        return $this->ReservePrice;
    }
    /**
     * Set ReservePrice value
     * @param int $reservePrice
     * @return \StructType\ItemRequest
     */
    public function setReservePrice($reservePrice = null)
    {
        // validation for constraint: int
        if (!is_null($reservePrice) && !(is_int($reservePrice) || ctype_digit($reservePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservePrice, true), gettype($reservePrice)), __LINE__);
        }
        $this->ReservePrice = $reservePrice;
        return $this;
    }
    /**
     * Get BuyItNowPrice value
     * @return int
     */
    public function getBuyItNowPrice()
    {
        return $this->BuyItNowPrice;
    }
    /**
     * Set BuyItNowPrice value
     * @param int $buyItNowPrice
     * @return \StructType\ItemRequest
     */
    public function setBuyItNowPrice($buyItNowPrice = null)
    {
        // validation for constraint: int
        if (!is_null($buyItNowPrice) && !(is_int($buyItNowPrice) || ctype_digit($buyItNowPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($buyItNowPrice, true), gettype($buyItNowPrice)), __LINE__);
        }
        $this->BuyItNowPrice = $buyItNowPrice;
        return $this;
    }
    /**
     * Get AcceptedBidderId value
     * @return int
     */
    public function getAcceptedBidderId()
    {
        return $this->AcceptedBidderId;
    }
    /**
     * Set AcceptedBidderId value
     * @param int $acceptedBidderId
     * @return \StructType\ItemRequest
     */
    public function setAcceptedBidderId($acceptedBidderId = null)
    {
        // validation for constraint: int
        if (!is_null($acceptedBidderId) && !(is_int($acceptedBidderId) || ctype_digit($acceptedBidderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($acceptedBidderId, true), gettype($acceptedBidderId)), __LINE__);
        }
        $this->AcceptedBidderId = $acceptedBidderId;
        return $this;
    }
    /**
     * Get CustomEndDate value
     * @return string
     */
    public function getCustomEndDate()
    {
        return $this->CustomEndDate;
    }
    /**
     * Set CustomEndDate value
     * @param string $customEndDate
     * @return \StructType\ItemRequest
     */
    public function setCustomEndDate($customEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($customEndDate) && !is_string($customEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customEndDate, true), gettype($customEndDate)), __LINE__);
        }
        $this->CustomEndDate = $customEndDate;
        return $this;
    }
    /**
     * Get ItemType value
     * @return int
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @param int $itemType
     * @return \StructType\ItemRequest
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get AutoCommit value
     * @return bool
     */
    public function getAutoCommit()
    {
        return $this->AutoCommit;
    }
    /**
     * Set AutoCommit value
     * @param bool $autoCommit
     * @return \StructType\ItemRequest
     */
    public function setAutoCommit($autoCommit = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoCommit) && !is_bool($autoCommit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoCommit, true), gettype($autoCommit)), __LINE__);
        }
        $this->AutoCommit = $autoCommit;
        return $this;
    }
    /**
     * Get VAT value
     * @return int
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param int $vAT
     * @return \StructType\ItemRequest
     */
    public function setVAT($vAT = null)
    {
        // validation for constraint: int
        if (!is_null($vAT) && !(is_int($vAT) || ctype_digit($vAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vAT, true), gettype($vAT)), __LINE__);
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ItemRequest
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get OwnReferences value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getOwnReferences()
    {
        return $this->OwnReferences;
    }
    /**
     * Set OwnReferences value
     * @param \ArrayType\ArrayOfString $ownReferences
     * @return \StructType\ItemRequest
     */
    public function setOwnReferences(\ArrayType\ArrayOfString $ownReferences = null)
    {
        $this->OwnReferences = $ownReferences;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ItemRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PaymentOptionIds value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getPaymentOptionIds()
    {
        return $this->PaymentOptionIds;
    }
    /**
     * Set PaymentOptionIds value
     * @param \ArrayType\ArrayOfInt $paymentOptionIds
     * @return \StructType\ItemRequest
     */
    public function setPaymentOptionIds(\ArrayType\ArrayOfInt $paymentOptionIds = null)
    {
        $this->PaymentOptionIds = $paymentOptionIds;
        return $this;
    }
    /**
     * Get ShippingOptions value
     * @return \ArrayType\ArrayOfItemShipping|null
     */
    public function getShippingOptions()
    {
        return $this->ShippingOptions;
    }
    /**
     * Set ShippingOptions value
     * @param \ArrayType\ArrayOfItemShipping $shippingOptions
     * @return \StructType\ItemRequest
     */
    public function setShippingOptions(\ArrayType\ArrayOfItemShipping $shippingOptions = null)
    {
        $this->ShippingOptions = $shippingOptions;
        return $this;
    }
    /**
     * Get ExpoItemIds value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getExpoItemIds()
    {
        return $this->ExpoItemIds;
    }
    /**
     * Set ExpoItemIds value
     * @param \ArrayType\ArrayOfInt $expoItemIds
     * @return \StructType\ItemRequest
     */
    public function setExpoItemIds(\ArrayType\ArrayOfInt $expoItemIds = null)
    {
        $this->ExpoItemIds = $expoItemIds;
        return $this;
    }
    /**
     * Get ItemAttributes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getItemAttributes()
    {
        return $this->ItemAttributes;
    }
    /**
     * Set ItemAttributes value
     * @param \ArrayType\ArrayOfInt $itemAttributes
     * @return \StructType\ItemRequest
     */
    public function setItemAttributes(\ArrayType\ArrayOfInt $itemAttributes = null)
    {
        $this->ItemAttributes = $itemAttributes;
        return $this;
    }
    /**
     * Get ShippingCondition value
     * @return string|null
     */
    public function getShippingCondition()
    {
        return $this->ShippingCondition;
    }
    /**
     * Set ShippingCondition value
     * @param string $shippingCondition
     * @return \StructType\ItemRequest
     */
    public function setShippingCondition($shippingCondition = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCondition) && !is_string($shippingCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingCondition, true), gettype($shippingCondition)), __LINE__);
        }
        $this->ShippingCondition = $shippingCondition;
        return $this;
    }
    /**
     * Get PaymentCondition value
     * @return string|null
     */
    public function getPaymentCondition()
    {
        return $this->PaymentCondition;
    }
    /**
     * Set PaymentCondition value
     * @param string $paymentCondition
     * @return \StructType\ItemRequest
     */
    public function setPaymentCondition($paymentCondition = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCondition) && !is_string($paymentCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCondition, true), gettype($paymentCondition)), __LINE__);
        }
        $this->PaymentCondition = $paymentCondition;
        return $this;
    }
    /**
     * Get CampaignCode value
     * @return string|null
     */
    public function getCampaignCode()
    {
        return $this->CampaignCode;
    }
    /**
     * Set CampaignCode value
     * @param string $campaignCode
     * @return \StructType\ItemRequest
     */
    public function setCampaignCode($campaignCode = null)
    {
        // validation for constraint: string
        if (!is_null($campaignCode) && !is_string($campaignCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignCode, true), gettype($campaignCode)), __LINE__);
        }
        $this->CampaignCode = $campaignCode;
        return $this;
    }
    /**
     * Get AttributeValues value
     * @return \StructType\ItemAttributeValues|null
     */
    public function getAttributeValues()
    {
        return $this->AttributeValues;
    }
    /**
     * Set AttributeValues value
     * @param \StructType\ItemAttributeValues $attributeValues
     * @return \StructType\ItemRequest
     */
    public function setAttributeValues(\StructType\ItemAttributeValues $attributeValues = null)
    {
        $this->AttributeValues = $attributeValues;
        return $this;
    }
}
