<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfigurationHeader StructType
 * Meta information extracted from the WSDL
 * - type: tns:ConfigurationHeader
 * @subpackage Structs
 */
class ConfigurationHeader extends AbstractStructBase
{
    /**
     * The Sandbox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Sandbox;
    /**
     * The MaxResultAge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxResultAge;
    /**
     * Constructor method for ConfigurationHeader
     * @uses ConfigurationHeader::setSandbox()
     * @uses ConfigurationHeader::setMaxResultAge()
     * @param int $sandbox
     * @param int $maxResultAge
     */
    public function __construct($sandbox = null, $maxResultAge = null)
    {
        $this
            ->setSandbox($sandbox)
            ->setMaxResultAge($maxResultAge);
    }
    /**
     * Get Sandbox value
     * @return int
     */
    public function getSandbox()
    {
        return $this->Sandbox;
    }
    /**
     * Set Sandbox value
     * @param int $sandbox
     * @return \StructType\ConfigurationHeader
     */
    public function setSandbox($sandbox = null)
    {
        // validation for constraint: int
        if (!is_null($sandbox) && !(is_int($sandbox) || ctype_digit($sandbox))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sandbox, true), gettype($sandbox)), __LINE__);
        }
        $this->Sandbox = $sandbox;
        return $this;
    }
    /**
     * Get MaxResultAge value
     * @return int
     */
    public function getMaxResultAge()
    {
        return $this->MaxResultAge;
    }
    /**
     * Set MaxResultAge value
     * @param int $maxResultAge
     * @return \StructType\ConfigurationHeader
     */
    public function setMaxResultAge($maxResultAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxResultAge) && !(is_int($maxResultAge) || ctype_digit($maxResultAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResultAge, true), gettype($maxResultAge)), __LINE__);
        }
        $this->MaxResultAge = $maxResultAge;
        return $this;
    }
}
