<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationHeader StructType
 * Meta information extracted from the WSDL
 * - type: tns:AuthenticationHeader
 * @subpackage Structs
 */
class AuthenticationHeader extends AbstractStructBase
{
    /**
     * The AppId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AppId;
    /**
     * The AppKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppKey;
    /**
     * Constructor method for AuthenticationHeader
     * @uses AuthenticationHeader::setAppId()
     * @uses AuthenticationHeader::setAppKey()
     * @param int $appId
     * @param string $appKey
     */
    public function __construct($appId = null, $appKey = null)
    {
        $this
            ->setAppId($appId)
            ->setAppKey($appKey);
    }
    /**
     * Get AppId value
     * @return int
     */
    public function getAppId()
    {
        return $this->AppId;
    }
    /**
     * Set AppId value
     * @param int $appId
     * @return \StructType\AuthenticationHeader
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: int
        if (!is_null($appId) && !(is_int($appId) || ctype_digit($appId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        $this->AppId = $appId;
        return $this;
    }
    /**
     * Get AppKey value
     * @return string|null
     */
    public function getAppKey()
    {
        return $this->AppKey;
    }
    /**
     * Set AppKey value
     * @param string $appKey
     * @return \StructType\AuthenticationHeader
     */
    public function setAppKey($appKey = null)
    {
        // validation for constraint: string
        if (!is_null($appKey) && !is_string($appKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appKey, true), gettype($appKey)), __LINE__);
        }
        $this->AppKey = $appKey;
        return $this;
    }
}
