<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddItemImage StructType
 * @subpackage Structs
 */
class AddItemImage extends AbstractStructBase
{
    /**
     * The requestId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $requestId;
    /**
     * The imageFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $imageFormat;
    /**
     * The hasMega
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $hasMega;
    /**
     * The imageData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $imageData;
    /**
     * Constructor method for AddItemImage
     * @uses AddItemImage::setRequestId()
     * @uses AddItemImage::setImageFormat()
     * @uses AddItemImage::setHasMega()
     * @uses AddItemImage::setImageData()
     * @param int $requestId
     * @param string $imageFormat
     * @param bool $hasMega
     * @param string $imageData
     */
    public function __construct($requestId = null, $imageFormat = null, $hasMega = null, $imageData = null)
    {
        $this
            ->setRequestId($requestId)
            ->setImageFormat($imageFormat)
            ->setHasMega($hasMega)
            ->setImageData($imageData);
    }
    /**
     * Get requestId value
     * @return int
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\AddItemImage
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !(is_int($requestId) || ctype_digit($requestId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get imageFormat value
     * @return string
     */
    public function getImageFormat()
    {
        return $this->imageFormat;
    }
    /**
     * Set imageFormat value
     * @uses \EnumType\ImageFormat::valueIsValid()
     * @uses \EnumType\ImageFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imageFormat
     * @return \StructType\AddItemImage
     */
    public function setImageFormat($imageFormat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImageFormat::valueIsValid($imageFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImageFormat', is_array($imageFormat) ? implode(', ', $imageFormat) : var_export($imageFormat, true), implode(', ', \EnumType\ImageFormat::getValidValues())), __LINE__);
        }
        $this->imageFormat = $imageFormat;
        return $this;
    }
    /**
     * Get hasMega value
     * @return bool
     */
    public function getHasMega()
    {
        return $this->hasMega;
    }
    /**
     * Set hasMega value
     * @param bool $hasMega
     * @return \StructType\AddItemImage
     */
    public function setHasMega($hasMega = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMega) && !is_bool($hasMega)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMega, true), gettype($hasMega)), __LINE__);
        }
        $this->hasMega = $hasMega;
        return $this;
    }
    /**
     * Get imageData value
     * @return string|null
     */
    public function getImageData()
    {
        return $this->imageData;
    }
    /**
     * Set imageData value
     * @param string $imageData
     * @return \StructType\AddItemImage
     */
    public function setImageData($imageData = null)
    {
        // validation for constraint: string
        if (!is_null($imageData) && !is_string($imageData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageData, true), gettype($imageData)), __LINE__);
        }
        $this->imageData = $imageData;
        return $this;
    }
}
