<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddItemCampaignCode StructType
 * @subpackage Structs
 */
class AddItemCampaignCode extends AbstractStructBase
{
    /**
     * The requestId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $requestId;
    /**
     * The campaignCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $campaignCode;
    /**
     * Constructor method for AddItemCampaignCode
     * @uses AddItemCampaignCode::setRequestId()
     * @uses AddItemCampaignCode::setCampaignCode()
     * @param int $requestId
     * @param string $campaignCode
     */
    public function __construct($requestId = null, $campaignCode = null)
    {
        $this
            ->setRequestId($requestId)
            ->setCampaignCode($campaignCode);
    }
    /**
     * Get requestId value
     * @return int
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\AddItemCampaignCode
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !(is_int($requestId) || ctype_digit($requestId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get campaignCode value
     * @return string|null
     */
    public function getCampaignCode()
    {
        return $this->campaignCode;
    }
    /**
     * Set campaignCode value
     * @param string $campaignCode
     * @return \StructType\AddItemCampaignCode
     */
    public function setCampaignCode($campaignCode = null)
    {
        // validation for constraint: string
        if (!is_null($campaignCode) && !is_string($campaignCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignCode, true), gettype($campaignCode)), __LINE__);
        }
        $this->campaignCode = $campaignCode;
        return $this;
    }
}
