<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVariantAttribute ArrayType
 * @subpackage Arrays
 */
class ArrayOfVariantAttribute extends AbstractStructArrayBase
{
    /**
     * The VariantAttribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VariantAttribute[]
     */
    public $VariantAttribute;
    /**
     * Constructor method for ArrayOfVariantAttribute
     * @uses ArrayOfVariantAttribute::setVariantAttribute()
     * @param \StructType\VariantAttribute[] $variantAttribute
     */
    public function __construct(array $variantAttribute = array())
    {
        $this
            ->setVariantAttribute($variantAttribute);
    }
    /**
     * Get VariantAttribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VariantAttribute[]|null
     */
    public function getVariantAttribute()
    {
        return isset($this->VariantAttribute) ? $this->VariantAttribute : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVariantAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariantAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariantAttributeForArrayConstraintsFromSetVariantAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfVariantAttributeVariantAttributeItem) {
            // validation for constraint: itemType
            if (!$arrayOfVariantAttributeVariantAttributeItem instanceof \StructType\VariantAttribute) {
                $invalidValues[] = is_object($arrayOfVariantAttributeVariantAttributeItem) ? get_class($arrayOfVariantAttributeVariantAttributeItem) : sprintf('%s(%s)', gettype($arrayOfVariantAttributeVariantAttributeItem), var_export($arrayOfVariantAttributeVariantAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VariantAttribute property can only contain items of type \StructType\VariantAttribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VariantAttribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VariantAttribute[] $variantAttribute
     * @return \ArrayType\ArrayOfVariantAttribute
     */
    public function setVariantAttribute(array $variantAttribute = array())
    {
        // validation for constraint: array
        if ('' !== ($variantAttributeArrayErrorMessage = self::validateVariantAttributeForArrayConstraintsFromSetVariantAttribute($variantAttribute))) {
            throw new \InvalidArgumentException($variantAttributeArrayErrorMessage, __LINE__);
        }
        if (is_null($variantAttribute) || (is_array($variantAttribute) && empty($variantAttribute))) {
            unset($this->VariantAttribute);
        } else {
            $this->VariantAttribute = $variantAttribute;
        }
        return $this;
    }
    /**
     * Add item to VariantAttribute value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantAttribute $item
     * @return \ArrayType\ArrayOfVariantAttribute
     */
    public function addToVariantAttribute(\StructType\VariantAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VariantAttribute) {
            throw new \InvalidArgumentException(sprintf('The VariantAttribute property can only contain items of type \StructType\VariantAttribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VariantAttribute[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VariantAttribute|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VariantAttribute|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VariantAttribute|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VariantAttribute|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VariantAttribute|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VariantAttribute
     */
    public function getAttributeName()
    {
        return 'VariantAttribute';
    }
}
