<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQueuedRequestResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfQueuedRequestResponse extends AbstractStructArrayBase
{
    /**
     * The QueuedRequestResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\QueuedRequestResponse[]
     */
    public $QueuedRequestResponse;
    /**
     * Constructor method for ArrayOfQueuedRequestResponse
     * @uses ArrayOfQueuedRequestResponse::setQueuedRequestResponse()
     * @param \StructType\QueuedRequestResponse[] $queuedRequestResponse
     */
    public function __construct(array $queuedRequestResponse = array())
    {
        $this
            ->setQueuedRequestResponse($queuedRequestResponse);
    }
    /**
     * Get QueuedRequestResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\QueuedRequestResponse[]|null
     */
    public function getQueuedRequestResponse()
    {
        return isset($this->QueuedRequestResponse) ? $this->QueuedRequestResponse : null;
    }
    /**
     * This method is responsible for validating the values passed to the setQueuedRequestResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQueuedRequestResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQueuedRequestResponseForArrayConstraintsFromSetQueuedRequestResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfQueuedRequestResponseQueuedRequestResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfQueuedRequestResponseQueuedRequestResponseItem instanceof \StructType\QueuedRequestResponse) {
                $invalidValues[] = is_object($arrayOfQueuedRequestResponseQueuedRequestResponseItem) ? get_class($arrayOfQueuedRequestResponseQueuedRequestResponseItem) : sprintf('%s(%s)', gettype($arrayOfQueuedRequestResponseQueuedRequestResponseItem), var_export($arrayOfQueuedRequestResponseQueuedRequestResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The QueuedRequestResponse property can only contain items of type \StructType\QueuedRequestResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set QueuedRequestResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\QueuedRequestResponse[] $queuedRequestResponse
     * @return \ArrayType\ArrayOfQueuedRequestResponse
     */
    public function setQueuedRequestResponse(array $queuedRequestResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($queuedRequestResponseArrayErrorMessage = self::validateQueuedRequestResponseForArrayConstraintsFromSetQueuedRequestResponse($queuedRequestResponse))) {
            throw new \InvalidArgumentException($queuedRequestResponseArrayErrorMessage, __LINE__);
        }
        if (is_null($queuedRequestResponse) || (is_array($queuedRequestResponse) && empty($queuedRequestResponse))) {
            unset($this->QueuedRequestResponse);
        } else {
            $this->QueuedRequestResponse = $queuedRequestResponse;
        }
        return $this;
    }
    /**
     * Add item to QueuedRequestResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\QueuedRequestResponse $item
     * @return \ArrayType\ArrayOfQueuedRequestResponse
     */
    public function addToQueuedRequestResponse(\StructType\QueuedRequestResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QueuedRequestResponse) {
            throw new \InvalidArgumentException(sprintf('The QueuedRequestResponse property can only contain items of type \StructType\QueuedRequestResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->QueuedRequestResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\QueuedRequestResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\QueuedRequestResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\QueuedRequestResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\QueuedRequestResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\QueuedRequestResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string QueuedRequestResponse
     */
    public function getAttributeName()
    {
        return 'QueuedRequestResponse';
    }
}
