<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNumberValues ArrayType
 * @subpackage Arrays
 */
class ArrayOfNumberValues extends AbstractStructArrayBase
{
    /**
     * The NumberValues
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NumberValues[]
     */
    public $NumberValues;
    /**
     * Constructor method for ArrayOfNumberValues
     * @uses ArrayOfNumberValues::setNumberValues()
     * @param \StructType\NumberValues[] $numberValues
     */
    public function __construct(array $numberValues = array())
    {
        $this
            ->setNumberValues($numberValues);
    }
    /**
     * Get NumberValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NumberValues[]|null
     */
    public function getNumberValues()
    {
        return isset($this->NumberValues) ? $this->NumberValues : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNumberValues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumberValues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNumberValuesForArrayConstraintsFromSetNumberValues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNumberValuesNumberValuesItem) {
            // validation for constraint: itemType
            if (!$arrayOfNumberValuesNumberValuesItem instanceof \StructType\NumberValues) {
                $invalidValues[] = is_object($arrayOfNumberValuesNumberValuesItem) ? get_class($arrayOfNumberValuesNumberValuesItem) : sprintf('%s(%s)', gettype($arrayOfNumberValuesNumberValuesItem), var_export($arrayOfNumberValuesNumberValuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NumberValues property can only contain items of type \StructType\NumberValues, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NumberValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NumberValues[] $numberValues
     * @return \ArrayType\ArrayOfNumberValues
     */
    public function setNumberValues(array $numberValues = array())
    {
        // validation for constraint: array
        if ('' !== ($numberValuesArrayErrorMessage = self::validateNumberValuesForArrayConstraintsFromSetNumberValues($numberValues))) {
            throw new \InvalidArgumentException($numberValuesArrayErrorMessage, __LINE__);
        }
        if (is_null($numberValues) || (is_array($numberValues) && empty($numberValues))) {
            unset($this->NumberValues);
        } else {
            $this->NumberValues = $numberValues;
        }
        return $this;
    }
    /**
     * Add item to NumberValues value
     * @throws \InvalidArgumentException
     * @param \StructType\NumberValues $item
     * @return \ArrayType\ArrayOfNumberValues
     */
    public function addToNumberValues(\StructType\NumberValues $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NumberValues) {
            throw new \InvalidArgumentException(sprintf('The NumberValues property can only contain items of type \StructType\NumberValues, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NumberValues[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NumberValues|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NumberValues|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NumberValues|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NumberValues|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NumberValues|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NumberValues
     */
    public function getAttributeName()
    {
        return 'NumberValues';
    }
}
