<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemShipping ArrayType
 * @subpackage Arrays
 */
class ArrayOfItemShipping extends AbstractStructArrayBase
{
    /**
     * The ItemShipping
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemShipping[]
     */
    public $ItemShipping;
    /**
     * Constructor method for ArrayOfItemShipping
     * @uses ArrayOfItemShipping::setItemShipping()
     * @param \StructType\ItemShipping[] $itemShipping
     */
    public function __construct(array $itemShipping = array())
    {
        $this
            ->setItemShipping($itemShipping);
    }
    /**
     * Get ItemShipping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemShipping[]|null
     */
    public function getItemShipping()
    {
        return isset($this->ItemShipping) ? $this->ItemShipping : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemShipping method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemShipping method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemShippingForArrayConstraintsFromSetItemShipping(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItemShippingItemShippingItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemShippingItemShippingItem instanceof \StructType\ItemShipping) {
                $invalidValues[] = is_object($arrayOfItemShippingItemShippingItem) ? get_class($arrayOfItemShippingItemShippingItem) : sprintf('%s(%s)', gettype($arrayOfItemShippingItemShippingItem), var_export($arrayOfItemShippingItemShippingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemShipping property can only contain items of type \StructType\ItemShipping, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemShipping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemShipping[] $itemShipping
     * @return \ArrayType\ArrayOfItemShipping
     */
    public function setItemShipping(array $itemShipping = array())
    {
        // validation for constraint: array
        if ('' !== ($itemShippingArrayErrorMessage = self::validateItemShippingForArrayConstraintsFromSetItemShipping($itemShipping))) {
            throw new \InvalidArgumentException($itemShippingArrayErrorMessage, __LINE__);
        }
        if (is_null($itemShipping) || (is_array($itemShipping) && empty($itemShipping))) {
            unset($this->ItemShipping);
        } else {
            $this->ItemShipping = $itemShipping;
        }
        return $this;
    }
    /**
     * Add item to ItemShipping value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemShipping $item
     * @return \ArrayType\ArrayOfItemShipping
     */
    public function addToItemShipping(\StructType\ItemShipping $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemShipping) {
            throw new \InvalidArgumentException(sprintf('The ItemShipping property can only contain items of type \StructType\ItemShipping, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemShipping[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemShipping|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemShipping|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemShipping|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemShipping|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemShipping|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemShipping
     */
    public function getAttributeName()
    {
        return 'ItemShipping';
    }
}
