<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionItem StructType
 * @subpackage Structs
 */
class TransactionItem extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The OwnReferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $OwnReferences;
    /**
     * Constructor method for TransactionItem
     * @uses TransactionItem::setId()
     * @uses TransactionItem::setType()
     * @uses TransactionItem::setTitle()
     * @uses TransactionItem::setOwnReferences()
     * @param int $id
     * @param string $type
     * @param string $title
     * @param \ArrayType\ArrayOfString $ownReferences
     */
    public function __construct($id = null, $type = null, $title = null, \ArrayType\ArrayOfString $ownReferences = null)
    {
        $this
            ->setId($id)
            ->setType($type)
            ->setTitle($title)
            ->setOwnReferences($ownReferences);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\TransactionItem
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ItemType::valueIsValid()
     * @uses \EnumType\ItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\TransactionItem
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\ItemType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\TransactionItem
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get OwnReferences value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getOwnReferences()
    {
        return $this->OwnReferences;
    }
    /**
     * Set OwnReferences value
     * @param \ArrayType\ArrayOfString $ownReferences
     * @return \StructType\TransactionItem
     */
    public function setOwnReferences(\ArrayType\ArrayOfString $ownReferences = null)
    {
        $this->OwnReferences = $ownReferences;
        return $this;
    }
}
