<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ResultCode EnumType
 * @subpackage Enumerations
 */
class ResultCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Ok'
     * @return string 'Ok'
     */
    const VALUE_OK = 'Ok';
    /**
     * Constant for value 'ImageProcessingError'
     * @return string 'ImageProcessingError'
     */
    const VALUE_IMAGE_PROCESSING_ERROR = 'ImageProcessingError';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'Timeout'
     * @return string 'Timeout'
     */
    const VALUE_TIMEOUT = 'Timeout';
    /**
     * Constant for value 'TryAgain'
     * @return string 'TryAgain'
     */
    const VALUE_TRY_AGAIN = 'TryAgain';
    /**
     * Constant for value 'UpdateNotAllowed'
     * @return string 'UpdateNotAllowed'
     */
    const VALUE_UPDATE_NOT_ALLOWED = 'UpdateNotAllowed';
    /**
     * Constant for value 'ReachedMaximumActiveItemsThreshold'
     * @return string 'ReachedMaximumActiveItemsThreshold'
     */
    const VALUE_REACHED_MAXIMUM_ACTIVE_ITEMS_THRESHOLD = 'ReachedMaximumActiveItemsThreshold';
    /**
     * Constant for value 'WaitingToBeProcessed'
     * @return string 'WaitingToBeProcessed'
     */
    const VALUE_WAITING_TO_BE_PROCESSED = 'WaitingToBeProcessed';
    /**
     * Constant for value 'Uncommited'
     * @return string 'Uncommited'
     */
    const VALUE_UNCOMMITED = 'Uncommited';
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_IMAGE_PROCESSING_ERROR
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_TIMEOUT
     * @uses self::VALUE_TRY_AGAIN
     * @uses self::VALUE_UPDATE_NOT_ALLOWED
     * @uses self::VALUE_REACHED_MAXIMUM_ACTIVE_ITEMS_THRESHOLD
     * @uses self::VALUE_WAITING_TO_BE_PROCESSED
     * @uses self::VALUE_UNCOMMITED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_IMAGE_PROCESSING_ERROR,
            self::VALUE_ERROR,
            self::VALUE_TIMEOUT,
            self::VALUE_TRY_AGAIN,
            self::VALUE_UPDATE_NOT_ALLOWED,
            self::VALUE_REACHED_MAXIMUM_ACTIVE_ITEMS_THRESHOLD,
            self::VALUE_WAITING_TO_BE_PROCESSED,
            self::VALUE_UNCOMMITED,
        );
    }
}
