<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRequestResult ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRequestResult
 * @subpackage Arrays
 */
class ArrayOfRequestResult extends AbstractStructArrayBase
{
    /**
     * The RequestResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RequestResult[]
     */
    public $RequestResult;
    /**
     * Constructor method for ArrayOfRequestResult
     * @uses ArrayOfRequestResult::setRequestResult()
     * @param \StructType\RequestResult[] $requestResult
     */
    public function __construct(array $requestResult = array())
    {
        $this
            ->setRequestResult($requestResult);
    }
    /**
     * Get RequestResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RequestResult[]|null
     */
    public function getRequestResult()
    {
        return isset($this->RequestResult) ? $this->RequestResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRequestResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestResultForArrayConstraintsFromSetRequestResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRequestResultRequestResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfRequestResultRequestResultItem instanceof \StructType\RequestResult) {
                $invalidValues[] = is_object($arrayOfRequestResultRequestResultItem) ? get_class($arrayOfRequestResultRequestResultItem) : sprintf('%s(%s)', gettype($arrayOfRequestResultRequestResultItem), var_export($arrayOfRequestResultRequestResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RequestResult property can only contain items of type \StructType\RequestResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RequestResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RequestResult[] $requestResult
     * @return \ArrayType\ArrayOfRequestResult
     */
    public function setRequestResult(array $requestResult = array())
    {
        // validation for constraint: array
        if ('' !== ($requestResultArrayErrorMessage = self::validateRequestResultForArrayConstraintsFromSetRequestResult($requestResult))) {
            throw new \InvalidArgumentException($requestResultArrayErrorMessage, __LINE__);
        }
        if (is_null($requestResult) || (is_array($requestResult) && empty($requestResult))) {
            unset($this->RequestResult);
        } else {
            $this->RequestResult = $requestResult;
        }
        return $this;
    }
    /**
     * Add item to RequestResult value
     * @throws \InvalidArgumentException
     * @param \StructType\RequestResult $item
     * @return \ArrayType\ArrayOfRequestResult
     */
    public function addToRequestResult(\StructType\RequestResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RequestResult) {
            throw new \InvalidArgumentException(sprintf('The RequestResult property can only contain items of type \StructType\RequestResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RequestResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RequestResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RequestResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RequestResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RequestResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RequestResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RequestResult
     */
    public function getAttributeName()
    {
        return 'RequestResult';
    }
}
