<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateCampaignCode StructType
 * @subpackage Structs
 */
class ValidateCampaignCode extends AbstractStructBase
{
    /**
     * The categoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $categoryId;
    /**
     * The campaignCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $campaignCode;
    /**
     * Constructor method for ValidateCampaignCode
     * @uses ValidateCampaignCode::setCategoryId()
     * @uses ValidateCampaignCode::setCampaignCode()
     * @param int $categoryId
     * @param string $campaignCode
     */
    public function __construct($categoryId = null, $campaignCode = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setCampaignCode($campaignCode);
    }
    /**
     * Get categoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \StructType\ValidateCampaignCode
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Get campaignCode value
     * @return string|null
     */
    public function getCampaignCode()
    {
        return $this->campaignCode;
    }
    /**
     * Set campaignCode value
     * @param string $campaignCode
     * @return \StructType\ValidateCampaignCode
     */
    public function setCampaignCode($campaignCode = null)
    {
        // validation for constraint: string
        if (!is_null($campaignCode) && !is_string($campaignCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignCode, true), gettype($campaignCode)), __LINE__);
        }
        $this->campaignCode = $campaignCode;
        return $this;
    }
}
