<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShopItemUpdateData StructType
 * @subpackage Structs
 */
class ShopItemUpdateData extends AbstractStructBase
{
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The ItemData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShopItemData
     */
    public $ItemData;
    /**
     * Constructor method for ShopItemUpdateData
     * @uses ShopItemUpdateData::setItemId()
     * @uses ShopItemUpdateData::setItemData()
     * @param int $itemId
     * @param \StructType\ShopItemData $itemData
     */
    public function __construct($itemId = null, \StructType\ShopItemData $itemData = null)
    {
        $this
            ->setItemId($itemId)
            ->setItemData($itemData);
    }
    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \StructType\ShopItemUpdateData
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ItemData value
     * @return \StructType\ShopItemData|null
     */
    public function getItemData()
    {
        return $this->ItemData;
    }
    /**
     * Set ItemData value
     * @param \StructType\ShopItemData $itemData
     * @return \StructType\ShopItemUpdateData
     */
    public function setItemData(\StructType\ShopItemData $itemData = null)
    {
        $this->ItemData = $itemData;
        return $this;
    }
}
