<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemShipping StructType
 * @subpackage Structs
 */
class ItemShipping extends AbstractStructBase
{
    /**
     * The ShippingOptionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ShippingOptionId;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Cost;
    /**
     * The ShippingProviderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ShippingProviderId;
    /**
     * The ShippingWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ShippingWeight;
    /**
     * The ShippingProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShippingProductId;
    /**
     * Constructor method for ItemShipping
     * @uses ItemShipping::setShippingOptionId()
     * @uses ItemShipping::setCost()
     * @uses ItemShipping::setShippingProviderId()
     * @uses ItemShipping::setShippingWeight()
     * @uses ItemShipping::setShippingProductId()
     * @param int $shippingOptionId
     * @param int $cost
     * @param int $shippingProviderId
     * @param float $shippingWeight
     * @param int $shippingProductId
     */
    public function __construct($shippingOptionId = null, $cost = null, $shippingProviderId = null, $shippingWeight = null, $shippingProductId = null)
    {
        $this
            ->setShippingOptionId($shippingOptionId)
            ->setCost($cost)
            ->setShippingProviderId($shippingProviderId)
            ->setShippingWeight($shippingWeight)
            ->setShippingProductId($shippingProductId);
    }
    /**
     * Get ShippingOptionId value
     * @return int
     */
    public function getShippingOptionId()
    {
        return $this->ShippingOptionId;
    }
    /**
     * Set ShippingOptionId value
     * @param int $shippingOptionId
     * @return \StructType\ItemShipping
     */
    public function setShippingOptionId($shippingOptionId = null)
    {
        // validation for constraint: int
        if (!is_null($shippingOptionId) && !(is_int($shippingOptionId) || ctype_digit($shippingOptionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingOptionId, true), gettype($shippingOptionId)), __LINE__);
        }
        $this->ShippingOptionId = $shippingOptionId;
        return $this;
    }
    /**
     * Get Cost value
     * @return int
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param int $cost
     * @return \StructType\ItemShipping
     */
    public function setCost($cost = null)
    {
        // validation for constraint: int
        if (!is_null($cost) && !(is_int($cost) || ctype_digit($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get ShippingProviderId value
     * @return int
     */
    public function getShippingProviderId()
    {
        return $this->ShippingProviderId;
    }
    /**
     * Set ShippingProviderId value
     * @param int $shippingProviderId
     * @return \StructType\ItemShipping
     */
    public function setShippingProviderId($shippingProviderId = null)
    {
        // validation for constraint: int
        if (!is_null($shippingProviderId) && !(is_int($shippingProviderId) || ctype_digit($shippingProviderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingProviderId, true), gettype($shippingProviderId)), __LINE__);
        }
        $this->ShippingProviderId = $shippingProviderId;
        return $this;
    }
    /**
     * Get ShippingWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getShippingWeight()
    {
        return isset($this->ShippingWeight) ? $this->ShippingWeight : null;
    }
    /**
     * Set ShippingWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $shippingWeight
     * @return \StructType\ItemShipping
     */
    public function setShippingWeight($shippingWeight = null)
    {
        // validation for constraint: float
        if (!is_null($shippingWeight) && !(is_float($shippingWeight) || is_numeric($shippingWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingWeight, true), gettype($shippingWeight)), __LINE__);
        }
        if (is_null($shippingWeight) || (is_array($shippingWeight) && empty($shippingWeight))) {
            unset($this->ShippingWeight);
        } else {
            $this->ShippingWeight = $shippingWeight;
        }
        return $this;
    }
    /**
     * Get ShippingProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShippingProductId()
    {
        return isset($this->ShippingProductId) ? $this->ShippingProductId : null;
    }
    /**
     * Set ShippingProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $shippingProductId
     * @return \StructType\ItemShipping
     */
    public function setShippingProductId($shippingProductId = null)
    {
        // validation for constraint: int
        if (!is_null($shippingProductId) && !(is_int($shippingProductId) || ctype_digit($shippingProductId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingProductId, true), gettype($shippingProductId)), __LINE__);
        }
        if (is_null($shippingProductId) || (is_array($shippingProductId) && empty($shippingProductId))) {
            unset($this->ShippingProductId);
        } else {
            $this->ShippingProductId = $shippingProductId;
        }
        return $this;
    }
}
