<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelBankIdVerification StructType
 * @subpackage Structs
 */
class CancelBankIdVerification extends AbstractStructBase
{
    /**
     * The request
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CancelBankIdVerification
     */
    public $request;
    /**
     * The BankIdOrderRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankIdOrderRef;
    /**
     * Constructor method for CancelBankIdVerification
     * @uses CancelBankIdVerification::setRequest()
     * @uses CancelBankIdVerification::setBankIdOrderRef()
     * @param \StructType\CancelBankIdVerification $request
     * @param string $bankIdOrderRef
     */
    public function __construct(\StructType\CancelBankIdVerification $request = null, $bankIdOrderRef = null)
    {
        $this
            ->setRequest($request)
            ->setBankIdOrderRef($bankIdOrderRef);
    }
    /**
     * Get request value
     * @return \StructType\CancelBankIdVerification|null
     */
    public function getRequest()
    {
        return $this->request;
    }
    /**
     * Set request value
     * @param \StructType\CancelBankIdVerification $request
     * @return \StructType\CancelBankIdVerification
     */
    public function setRequest(\StructType\CancelBankIdVerification $request = null)
    {
        $this->request = $request;
        return $this;
    }
    /**
     * Get BankIdOrderRef value
     * @return string|null
     */
    public function getBankIdOrderRef()
    {
        return $this->BankIdOrderRef;
    }
    /**
     * Set BankIdOrderRef value
     * @param string $bankIdOrderRef
     * @return \StructType\CancelBankIdVerification
     */
    public function setBankIdOrderRef($bankIdOrderRef = null)
    {
        // validation for constraint: string
        if (!is_null($bankIdOrderRef) && !is_string($bankIdOrderRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankIdOrderRef, true), gettype($bankIdOrderRef)), __LINE__);
        }
        $this->BankIdOrderRef = $bankIdOrderRef;
        return $this;
    }
}
