<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BeginBankIdVerificationResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BeginBankIdVerificationResult
 * @subpackage Structs
 */
class BeginBankIdVerificationResult extends AbstractStructBase
{
    /**
     * The BankIdOrderRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankIdOrderRef;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * The QrData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QrData;
    /**
     * Constructor method for BeginBankIdVerificationResult
     * @uses BeginBankIdVerificationResult::setBankIdOrderRef()
     * @uses BeginBankIdVerificationResult::setError()
     * @uses BeginBankIdVerificationResult::setQrData()
     * @param string $bankIdOrderRef
     * @param string $error
     * @param string $qrData
     */
    public function __construct($bankIdOrderRef = null, $error = null, $qrData = null)
    {
        $this
            ->setBankIdOrderRef($bankIdOrderRef)
            ->setError($error)
            ->setQrData($qrData);
    }
    /**
     * Get BankIdOrderRef value
     * @return string|null
     */
    public function getBankIdOrderRef()
    {
        return $this->BankIdOrderRef;
    }
    /**
     * Set BankIdOrderRef value
     * @param string $bankIdOrderRef
     * @return \StructType\BeginBankIdVerificationResult
     */
    public function setBankIdOrderRef($bankIdOrderRef = null)
    {
        // validation for constraint: string
        if (!is_null($bankIdOrderRef) && !is_string($bankIdOrderRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankIdOrderRef, true), gettype($bankIdOrderRef)), __LINE__);
        }
        $this->BankIdOrderRef = $bankIdOrderRef;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\BeginBankIdVerificationResult
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get QrData value
     * @return string|null
     */
    public function getQrData()
    {
        return $this->QrData;
    }
    /**
     * Set QrData value
     * @param string $qrData
     * @return \StructType\BeginBankIdVerificationResult
     */
    public function setQrData($qrData = null)
    {
        // validation for constraint: string
        if (!is_null($qrData) && !is_string($qrData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qrData, true), gettype($qrData)), __LINE__);
        }
        $this->QrData = $qrData;
        return $this;
    }
}
