<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticationHeader $authenticationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationHeader(\StructType\AuthenticationHeader $authenticationHeader, $nameSpace = 'http://api.tradera.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationHeader', $authenticationHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the AuthorizationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthorizationHeader $authorizationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthorizationHeader(\StructType\AuthorizationHeader $authorizationHeader, $nameSpace = 'http://api.tradera.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthorizationHeader', $authorizationHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the ConfigurationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ConfigurationHeader $configurationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderConfigurationHeader(\StructType\ConfigurationHeader $configurationHeader, $nameSpace = 'http://api.tradera.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ConfigurationHeader', $configurationHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddItem $parameters
     * @return \StructType\AddItemResponse|bool
     */
    public function AddItem(\StructType\AddItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItemXml
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddItemXml $parameters
     * @return \StructType\AddItemXmlResponse|bool
     */
    public function AddItemXml(\StructType\AddItemXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItemXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItemImage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddItemImage $parameters
     * @return \StructType\AddItemImageResponse|bool
     */
    public function AddItemImage(\StructType\AddItemImage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItemImage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItemCampaignCode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddItemCampaignCode $parameters
     * @return \StructType\AddItemCampaignCodeResponse|bool
     */
    public function AddItemCampaignCode(\StructType\AddItemCampaignCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItemCampaignCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItemCommit
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddItemCommit $parameters
     * @return \StructType\AddItemCommitResponse|bool
     */
    public function AddItemCommit(\StructType\AddItemCommit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItemCommit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddShopItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddShopItem $parameters
     * @return \StructType\AddShopItemResponse|bool
     */
    public function AddShopItem(\StructType\AddShopItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddShopItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddShopItemVariant
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddShopItemVariant $parameters
     * @return \StructType\AddShopItemVariantResponse|bool
     */
    public function AddShopItemVariant(\StructType\AddShopItemVariant $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddShopItemVariant($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddItemCampaignCodeResponse|\StructType\AddItemCommitResponse|\StructType\AddItemImageResponse|\StructType\AddItemResponse|\StructType\AddItemXmlResponse|\StructType\AddShopItemResponse|\StructType\AddShopItemVariantResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
