<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTermValues ArrayType
 * @subpackage Arrays
 */
class ArrayOfTermValues extends AbstractStructArrayBase
{
    /**
     * The TermValues
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TermValues[]
     */
    public $TermValues;
    /**
     * Constructor method for ArrayOfTermValues
     * @uses ArrayOfTermValues::setTermValues()
     * @param \StructType\TermValues[] $termValues
     */
    public function __construct(array $termValues = array())
    {
        $this
            ->setTermValues($termValues);
    }
    /**
     * Get TermValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TermValues[]|null
     */
    public function getTermValues()
    {
        return isset($this->TermValues) ? $this->TermValues : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTermValues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTermValues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTermValuesForArrayConstraintsFromSetTermValues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTermValuesTermValuesItem) {
            // validation for constraint: itemType
            if (!$arrayOfTermValuesTermValuesItem instanceof \StructType\TermValues) {
                $invalidValues[] = is_object($arrayOfTermValuesTermValuesItem) ? get_class($arrayOfTermValuesTermValuesItem) : sprintf('%s(%s)', gettype($arrayOfTermValuesTermValuesItem), var_export($arrayOfTermValuesTermValuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TermValues property can only contain items of type \StructType\TermValues, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TermValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TermValues[] $termValues
     * @return \ArrayType\ArrayOfTermValues
     */
    public function setTermValues(array $termValues = array())
    {
        // validation for constraint: array
        if ('' !== ($termValuesArrayErrorMessage = self::validateTermValuesForArrayConstraintsFromSetTermValues($termValues))) {
            throw new \InvalidArgumentException($termValuesArrayErrorMessage, __LINE__);
        }
        if (is_null($termValues) || (is_array($termValues) && empty($termValues))) {
            unset($this->TermValues);
        } else {
            $this->TermValues = $termValues;
        }
        return $this;
    }
    /**
     * Add item to TermValues value
     * @throws \InvalidArgumentException
     * @param \StructType\TermValues $item
     * @return \ArrayType\ArrayOfTermValues
     */
    public function addToTermValues(\StructType\TermValues $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TermValues) {
            throw new \InvalidArgumentException(sprintf('The TermValues property can only contain items of type \StructType\TermValues, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TermValues[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TermValues|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TermValues|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TermValues|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TermValues|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TermValues|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TermValues
     */
    public function getAttributeName()
    {
        return 'TermValues';
    }
}
