<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNumberAttributeValue ArrayType
 * @subpackage Arrays
 */
class ArrayOfNumberAttributeValue extends AbstractStructArrayBase
{
    /**
     * The NumberAttributeValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NumberAttributeValue[]
     */
    public $NumberAttributeValue;
    /**
     * Constructor method for ArrayOfNumberAttributeValue
     * @uses ArrayOfNumberAttributeValue::setNumberAttributeValue()
     * @param \StructType\NumberAttributeValue[] $numberAttributeValue
     */
    public function __construct(array $numberAttributeValue = array())
    {
        $this
            ->setNumberAttributeValue($numberAttributeValue);
    }
    /**
     * Get NumberAttributeValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NumberAttributeValue[]|null
     */
    public function getNumberAttributeValue()
    {
        return isset($this->NumberAttributeValue) ? $this->NumberAttributeValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNumberAttributeValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumberAttributeValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNumberAttributeValueForArrayConstraintsFromSetNumberAttributeValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNumberAttributeValueNumberAttributeValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfNumberAttributeValueNumberAttributeValueItem instanceof \StructType\NumberAttributeValue) {
                $invalidValues[] = is_object($arrayOfNumberAttributeValueNumberAttributeValueItem) ? get_class($arrayOfNumberAttributeValueNumberAttributeValueItem) : sprintf('%s(%s)', gettype($arrayOfNumberAttributeValueNumberAttributeValueItem), var_export($arrayOfNumberAttributeValueNumberAttributeValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NumberAttributeValue property can only contain items of type \StructType\NumberAttributeValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NumberAttributeValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NumberAttributeValue[] $numberAttributeValue
     * @return \ArrayType\ArrayOfNumberAttributeValue
     */
    public function setNumberAttributeValue(array $numberAttributeValue = array())
    {
        // validation for constraint: array
        if ('' !== ($numberAttributeValueArrayErrorMessage = self::validateNumberAttributeValueForArrayConstraintsFromSetNumberAttributeValue($numberAttributeValue))) {
            throw new \InvalidArgumentException($numberAttributeValueArrayErrorMessage, __LINE__);
        }
        if (is_null($numberAttributeValue) || (is_array($numberAttributeValue) && empty($numberAttributeValue))) {
            unset($this->NumberAttributeValue);
        } else {
            $this->NumberAttributeValue = $numberAttributeValue;
        }
        return $this;
    }
    /**
     * Add item to NumberAttributeValue value
     * @throws \InvalidArgumentException
     * @param \StructType\NumberAttributeValue $item
     * @return \ArrayType\ArrayOfNumberAttributeValue
     */
    public function addToNumberAttributeValue(\StructType\NumberAttributeValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NumberAttributeValue) {
            throw new \InvalidArgumentException(sprintf('The NumberAttributeValue property can only contain items of type \StructType\NumberAttributeValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NumberAttributeValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NumberAttributeValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NumberAttributeValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NumberAttributeValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NumberAttributeValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NumberAttributeValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NumberAttributeValue
     */
    public function getAttributeName()
    {
        return 'NumberAttributeValue';
    }
}
