<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemImageData ArrayType
 * @subpackage Arrays
 */
class ArrayOfItemImageData extends AbstractStructArrayBase
{
    /**
     * The ItemImageData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemImageData[]
     */
    public $ItemImageData;
    /**
     * Constructor method for ArrayOfItemImageData
     * @uses ArrayOfItemImageData::setItemImageData()
     * @param \StructType\ItemImageData[] $itemImageData
     */
    public function __construct(array $itemImageData = array())
    {
        $this
            ->setItemImageData($itemImageData);
    }
    /**
     * Get ItemImageData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemImageData[]|null
     */
    public function getItemImageData()
    {
        return isset($this->ItemImageData) ? $this->ItemImageData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemImageData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemImageData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemImageDataForArrayConstraintsFromSetItemImageData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItemImageDataItemImageDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemImageDataItemImageDataItem instanceof \StructType\ItemImageData) {
                $invalidValues[] = is_object($arrayOfItemImageDataItemImageDataItem) ? get_class($arrayOfItemImageDataItemImageDataItem) : sprintf('%s(%s)', gettype($arrayOfItemImageDataItemImageDataItem), var_export($arrayOfItemImageDataItemImageDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemImageData property can only contain items of type \StructType\ItemImageData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemImageData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemImageData[] $itemImageData
     * @return \ArrayType\ArrayOfItemImageData
     */
    public function setItemImageData(array $itemImageData = array())
    {
        // validation for constraint: array
        if ('' !== ($itemImageDataArrayErrorMessage = self::validateItemImageDataForArrayConstraintsFromSetItemImageData($itemImageData))) {
            throw new \InvalidArgumentException($itemImageDataArrayErrorMessage, __LINE__);
        }
        if (is_null($itemImageData) || (is_array($itemImageData) && empty($itemImageData))) {
            unset($this->ItemImageData);
        } else {
            $this->ItemImageData = $itemImageData;
        }
        return $this;
    }
    /**
     * Add item to ItemImageData value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemImageData $item
     * @return \ArrayType\ArrayOfItemImageData
     */
    public function addToItemImageData(\StructType\ItemImageData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemImageData) {
            throw new \InvalidArgumentException(sprintf('The ItemImageData property can only contain items of type \StructType\ItemImageData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemImageData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemImageData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemImageData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemImageData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemImageData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemImageData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemImageData
     */
    public function getAttributeName()
    {
        return 'ItemImageData';
    }
}
