<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDecimal ArrayType
 * @subpackage Arrays
 */
class ArrayOfDecimal extends AbstractStructArrayBase
{
    /**
     * The decimal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var float[]
     */
    public $decimal;
    /**
     * Constructor method for ArrayOfDecimal
     * @uses ArrayOfDecimal::setDecimal()
     * @param float[] $decimal
     */
    public function __construct(array $decimal = array())
    {
        $this
            ->setDecimal($decimal);
    }
    /**
     * Get decimal value
     * @return float[]|null
     */
    public function getDecimal()
    {
        return $this->decimal;
    }
    /**
     * This method is responsible for validating the values passed to the setDecimal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDecimal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDecimalForArrayConstraintsFromSetDecimal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDecimalDecimalItem) {
            // validation for constraint: itemType
            if (!(is_float($arrayOfDecimalDecimalItem) || is_numeric($arrayOfDecimalDecimalItem))) {
                $invalidValues[] = is_object($arrayOfDecimalDecimalItem) ? get_class($arrayOfDecimalDecimalItem) : sprintf('%s(%s)', gettype($arrayOfDecimalDecimalItem), var_export($arrayOfDecimalDecimalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The decimal property can only contain items of type decimal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set decimal value
     * @throws \InvalidArgumentException
     * @param float[] $decimal
     * @return \ArrayType\ArrayOfDecimal
     */
    public function setDecimal(array $decimal = array())
    {
        // validation for constraint: array
        if ('' !== ($decimalArrayErrorMessage = self::validateDecimalForArrayConstraintsFromSetDecimal($decimal))) {
            throw new \InvalidArgumentException($decimalArrayErrorMessage, __LINE__);
        }
        $this->decimal = $decimal;
        return $this;
    }
    /**
     * Add item to decimal value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \ArrayType\ArrayOfDecimal
     */
    public function addToDecimal($item)
    {
        // validation for constraint: itemType
        if (!(is_float($item) || is_numeric($item))) {
            throw new \InvalidArgumentException(sprintf('The decimal property can only contain items of type decimal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->decimal[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return float|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return float|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return float|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return float|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return float|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string decimal
     */
    public function getAttributeName()
    {
        return 'decimal';
    }
}
