<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.tradera.com/v3/RestrictedService.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.tradera.com/v3/RestrictedService.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$get->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$get->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for GetItem operation/method
 */
if ($get->GetItem(new \StructType\GetItem()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerItems operation/method
 */
if ($get->GetSellerItems(new \StructType\GetSellerItems()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSellerTransactions operation/method
 */
if ($get->GetSellerTransactions(new \StructType\GetSellerTransactions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRequestResults operation/method
 */
if ($get->GetRequestResults(new \StructType\GetRequestResults()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShopSettings operation/method
 */
if ($get->GetShopSettings(new \StructType\GetShopSettings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUpdatedSellerItems operation/method
 */
if ($get->GetUpdatedSellerItems(new \StructType\GetUpdatedSellerItems()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserInfo operation/method
 */
if ($get->GetUserInfo(new \StructType\GetUserInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMemberPaymentOptions operation/method
 */
if ($get->GetMemberPaymentOptions(new \StructType\GetMemberPaymentOptions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBankIdVerificationProgress operation/method
 */
if ($get->GetBankIdVerificationProgress(new \StructType\GetBankIdVerificationProgress()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$add->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$add->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for AddItem operation/method
 */
if ($add->AddItem(new \StructType\AddItem()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItemXml operation/method
 */
if ($add->AddItemXml(new \StructType\AddItemXml()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItemImage operation/method
 */
if ($add->AddItemImage(new \StructType\AddItemImage()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItemCampaignCode operation/method
 */
if ($add->AddItemCampaignCode(new \StructType\AddItemCampaignCode()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItemCommit operation/method
 */
if ($add->AddItemCommit(new \StructType\AddItemCommit()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddShopItem operation/method
 */
if ($add->AddShopItem(new \StructType\AddShopItem()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddShopItemVariant operation/method
 */
if ($add->AddShopItemVariant(new \StructType\AddShopItemVariant()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
$validate->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$validate->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$validate->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for ValidateCampaignCode operation/method
 */
if ($validate->ValidateCampaignCode(new \StructType\ValidateCampaignCode()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Leave ServiceType
 */
$leave = new \ServiceType\Leave($options);
$leave->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$leave->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$leave->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for LeaveFeedback operation/method
 */
if ($leave->LeaveFeedback(new \StructType\LeaveFeedback()) !== false) {
    print_r($leave->getResult());
} else {
    print_r($leave->getLastError());
}
/**
 * Sample call for LeaveOrderFeedbackToBuyer operation/method
 */
if ($leave->LeaveOrderFeedbackToBuyer(new \StructType\LeaveOrderFeedbackToBuyer()) !== false) {
    print_r($leave->getResult());
} else {
    print_r($leave->getLastError());
}
/**
 * Samples for End ServiceType
 */
$end = new \ServiceType\End($options);
$end->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$end->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$end->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for EndItem operation/method
 */
if ($end->EndItem(new \StructType\EndItem()) !== false) {
    print_r($end->getResult());
} else {
    print_r($end->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$update->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$update->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for UpdateShopItem operation/method
 */
if ($update->UpdateShopItem(new \StructType\UpdateShopItem()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateShopItemVariant operation/method
 */
if ($update->UpdateShopItemVariant(new \StructType\UpdateShopItemVariant()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateTransactionStatus operation/method
 */
if ($update->UpdateTransactionStatus(new \StructType\UpdateTransactionStatus()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
$remove->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$remove->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$remove->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for RemoveShopItem operation/method
 */
if ($remove->RemoveShopItem(new \StructType\RemoveShopItem()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
$set->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$set->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$set->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for SetShopSettings operation/method
 */
if ($set->SetShopSettings(new \StructType\SetShopSettings()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPriceOnShopItems operation/method
 */
if ($set->SetPriceOnShopItems(new \StructType\SetPriceOnShopItems()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPricesOnNonShopItems operation/method
 */
if ($set->SetPricesOnNonShopItems(new \StructType\SetPricesOnNonShopItems()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetActivateDateOnShopItems operation/method
 */
if ($set->SetActivateDateOnShopItems(new \StructType\SetActivateDateOnShopItems()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetQuantityOnShopItems operation/method
 */
if ($set->SetQuantityOnShopItems(new \StructType\SetQuantityOnShopItems()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Begin ServiceType
 */
$begin = new \ServiceType\Begin($options);
$begin->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$begin->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$begin->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for BeginBankIdVerification operation/method
 */
if ($begin->BeginBankIdVerification(new \StructType\BeginBankIdVerification()) !== false) {
    print_r($begin->getResult());
} else {
    print_r($begin->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
$cancel->setSoapHeaderAuthenticationHeader(new \StructType\AuthenticationHeader());
$cancel->setSoapHeaderAuthorizationHeader(new \StructType\AuthorizationHeader());
$cancel->setSoapHeaderConfigurationHeader(new \StructType\ConfigurationHeader());
/**
 * Sample call for CancelBankIdVerification operation/method
 */
if ($cancel->CancelBankIdVerification(new \StructType\CancelBankIdVerification()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
