<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShopLogoData StructType
 * @subpackage Structs
 */
class ShopLogoData extends AbstractStructBase
{
    /**
     * The ImageFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ImageFormat;
    /**
     * The RemoveLogo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RemoveLogo;
    /**
     * The ImageData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageData;
    /**
     * Constructor method for ShopLogoData
     * @uses ShopLogoData::setImageFormat()
     * @uses ShopLogoData::setRemoveLogo()
     * @uses ShopLogoData::setImageData()
     * @param string $imageFormat
     * @param bool $removeLogo
     * @param string $imageData
     */
    public function __construct($imageFormat = null, $removeLogo = null, $imageData = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setRemoveLogo($removeLogo)
            ->setImageData($imageData);
    }
    /**
     * Get ImageFormat value
     * @return string
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @uses \EnumType\ImageFormat::valueIsValid()
     * @uses \EnumType\ImageFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imageFormat
     * @return \StructType\ShopLogoData
     */
    public function setImageFormat($imageFormat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImageFormat::valueIsValid($imageFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImageFormat', is_array($imageFormat) ? implode(', ', $imageFormat) : var_export($imageFormat, true), implode(', ', \EnumType\ImageFormat::getValidValues())), __LINE__);
        }
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Get RemoveLogo value
     * @return bool
     */
    public function getRemoveLogo()
    {
        return $this->RemoveLogo;
    }
    /**
     * Set RemoveLogo value
     * @param bool $removeLogo
     * @return \StructType\ShopLogoData
     */
    public function setRemoveLogo($removeLogo = null)
    {
        // validation for constraint: boolean
        if (!is_null($removeLogo) && !is_bool($removeLogo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removeLogo, true), gettype($removeLogo)), __LINE__);
        }
        $this->RemoveLogo = $removeLogo;
        return $this;
    }
    /**
     * Get ImageData value
     * @return string|null
     */
    public function getImageData()
    {
        return $this->ImageData;
    }
    /**
     * Set ImageData value
     * @param string $imageData
     * @return \StructType\ShopLogoData
     */
    public function setImageData($imageData = null)
    {
        // validation for constraint: string
        if (!is_null($imageData) && !is_string($imageData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageData, true), gettype($imageData)), __LINE__);
        }
        $this->ImageData = $imageData;
        return $this;
    }
}
