<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShopItemVariantData StructType
 * @subpackage Structs
 */
class ShopItemVariantData extends AbstractStructBase
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CategoryId;
    /**
     * The AcceptedBuyerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AcceptedBuyerId;
    /**
     * The VAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $VAT;
    /**
     * The ActivateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ActivateDate;
    /**
     * The DeactivateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeactivateDate;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The AbsoluteQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AbsoluteQuantity;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ExternalId;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Price;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ShippingOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItemShipping
     */
    public $ShippingOptions;
    /**
     * The PaymentOptionIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $PaymentOptionIds;
    /**
     * The ItemAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $ItemAttributes;
    /**
     * The ShippingCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCondition;
    /**
     * The PaymentCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCondition;
    /**
     * The OwnReferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $OwnReferences;
    /**
     * The ItemImages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItemImageData
     */
    public $ItemImages;
    /**
     * The SellerPartNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SellerPartNo;
    /**
     * The VariantData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VariantData
     */
    public $VariantData;
    /**
     * The AttributeValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ItemAttributeValues
     */
    public $AttributeValues;
    /**
     * The DescriptionLanguageCodeIso2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescriptionLanguageCodeIso2;
    /**
     * Constructor method for ShopItemVariantData
     * @uses ShopItemVariantData::setCategoryId()
     * @uses ShopItemVariantData::setAcceptedBuyerId()
     * @uses ShopItemVariantData::setVAT()
     * @uses ShopItemVariantData::setActivateDate()
     * @uses ShopItemVariantData::setDeactivateDate()
     * @uses ShopItemVariantData::setQuantity()
     * @uses ShopItemVariantData::setAbsoluteQuantity()
     * @uses ShopItemVariantData::setExternalId()
     * @uses ShopItemVariantData::setPrice()
     * @uses ShopItemVariantData::setTitle()
     * @uses ShopItemVariantData::setDescription()
     * @uses ShopItemVariantData::setShippingOptions()
     * @uses ShopItemVariantData::setPaymentOptionIds()
     * @uses ShopItemVariantData::setItemAttributes()
     * @uses ShopItemVariantData::setShippingCondition()
     * @uses ShopItemVariantData::setPaymentCondition()
     * @uses ShopItemVariantData::setOwnReferences()
     * @uses ShopItemVariantData::setItemImages()
     * @uses ShopItemVariantData::setSellerPartNo()
     * @uses ShopItemVariantData::setVariantData()
     * @uses ShopItemVariantData::setAttributeValues()
     * @uses ShopItemVariantData::setDescriptionLanguageCodeIso2()
     * @param int $categoryId
     * @param int $acceptedBuyerId
     * @param int $vAT
     * @param string $activateDate
     * @param string $deactivateDate
     * @param int $quantity
     * @param int $absoluteQuantity
     * @param int $externalId
     * @param int $price
     * @param string $title
     * @param string $description
     * @param \ArrayType\ArrayOfItemShipping $shippingOptions
     * @param \ArrayType\ArrayOfInt $paymentOptionIds
     * @param \ArrayType\ArrayOfInt $itemAttributes
     * @param string $shippingCondition
     * @param string $paymentCondition
     * @param \ArrayType\ArrayOfString $ownReferences
     * @param \ArrayType\ArrayOfItemImageData $itemImages
     * @param string $sellerPartNo
     * @param \StructType\VariantData $variantData
     * @param \StructType\ItemAttributeValues $attributeValues
     * @param string $descriptionLanguageCodeIso2
     */
    public function __construct($categoryId = null, $acceptedBuyerId = null, $vAT = null, $activateDate = null, $deactivateDate = null, $quantity = null, $absoluteQuantity = null, $externalId = null, $price = null, $title = null, $description = null, \ArrayType\ArrayOfItemShipping $shippingOptions = null, \ArrayType\ArrayOfInt $paymentOptionIds = null, \ArrayType\ArrayOfInt $itemAttributes = null, $shippingCondition = null, $paymentCondition = null, \ArrayType\ArrayOfString $ownReferences = null, \ArrayType\ArrayOfItemImageData $itemImages = null, $sellerPartNo = null, \StructType\VariantData $variantData = null, \StructType\ItemAttributeValues $attributeValues = null, $descriptionLanguageCodeIso2 = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setAcceptedBuyerId($acceptedBuyerId)
            ->setVAT($vAT)
            ->setActivateDate($activateDate)
            ->setDeactivateDate($deactivateDate)
            ->setQuantity($quantity)
            ->setAbsoluteQuantity($absoluteQuantity)
            ->setExternalId($externalId)
            ->setPrice($price)
            ->setTitle($title)
            ->setDescription($description)
            ->setShippingOptions($shippingOptions)
            ->setPaymentOptionIds($paymentOptionIds)
            ->setItemAttributes($itemAttributes)
            ->setShippingCondition($shippingCondition)
            ->setPaymentCondition($paymentCondition)
            ->setOwnReferences($ownReferences)
            ->setItemImages($itemImages)
            ->setSellerPartNo($sellerPartNo)
            ->setVariantData($variantData)
            ->setAttributeValues($attributeValues)
            ->setDescriptionLanguageCodeIso2($descriptionLanguageCodeIso2);
    }
    /**
     * Get CategoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param int $categoryId
     * @return \StructType\ShopItemVariantData
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get AcceptedBuyerId value
     * @return int
     */
    public function getAcceptedBuyerId()
    {
        return $this->AcceptedBuyerId;
    }
    /**
     * Set AcceptedBuyerId value
     * @param int $acceptedBuyerId
     * @return \StructType\ShopItemVariantData
     */
    public function setAcceptedBuyerId($acceptedBuyerId = null)
    {
        // validation for constraint: int
        if (!is_null($acceptedBuyerId) && !(is_int($acceptedBuyerId) || ctype_digit($acceptedBuyerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($acceptedBuyerId, true), gettype($acceptedBuyerId)), __LINE__);
        }
        $this->AcceptedBuyerId = $acceptedBuyerId;
        return $this;
    }
    /**
     * Get VAT value
     * @return int
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param int $vAT
     * @return \StructType\ShopItemVariantData
     */
    public function setVAT($vAT = null)
    {
        // validation for constraint: int
        if (!is_null($vAT) && !(is_int($vAT) || ctype_digit($vAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vAT, true), gettype($vAT)), __LINE__);
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get ActivateDate value
     * @return string
     */
    public function getActivateDate()
    {
        return $this->ActivateDate;
    }
    /**
     * Set ActivateDate value
     * @param string $activateDate
     * @return \StructType\ShopItemVariantData
     */
    public function setActivateDate($activateDate = null)
    {
        // validation for constraint: string
        if (!is_null($activateDate) && !is_string($activateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activateDate, true), gettype($activateDate)), __LINE__);
        }
        $this->ActivateDate = $activateDate;
        return $this;
    }
    /**
     * Get DeactivateDate value
     * @return string
     */
    public function getDeactivateDate()
    {
        return $this->DeactivateDate;
    }
    /**
     * Set DeactivateDate value
     * @param string $deactivateDate
     * @return \StructType\ShopItemVariantData
     */
    public function setDeactivateDate($deactivateDate = null)
    {
        // validation for constraint: string
        if (!is_null($deactivateDate) && !is_string($deactivateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deactivateDate, true), gettype($deactivateDate)), __LINE__);
        }
        $this->DeactivateDate = $deactivateDate;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ShopItemVariantData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get AbsoluteQuantity value
     * @return int
     */
    public function getAbsoluteQuantity()
    {
        return $this->AbsoluteQuantity;
    }
    /**
     * Set AbsoluteQuantity value
     * @param int $absoluteQuantity
     * @return \StructType\ShopItemVariantData
     */
    public function setAbsoluteQuantity($absoluteQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($absoluteQuantity) && !(is_int($absoluteQuantity) || ctype_digit($absoluteQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($absoluteQuantity, true), gettype($absoluteQuantity)), __LINE__);
        }
        $this->AbsoluteQuantity = $absoluteQuantity;
        return $this;
    }
    /**
     * Get ExternalId value
     * @return int
     */
    public function getExternalId()
    {
        return $this->ExternalId;
    }
    /**
     * Set ExternalId value
     * @param int $externalId
     * @return \StructType\ShopItemVariantData
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: int
        if (!is_null($externalId) && !(is_int($externalId) || ctype_digit($externalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->ExternalId = $externalId;
        return $this;
    }
    /**
     * Get Price value
     * @return int
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param int $price
     * @return \StructType\ShopItemVariantData
     */
    public function setPrice($price = null)
    {
        // validation for constraint: int
        if (!is_null($price) && !(is_int($price) || ctype_digit($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ShopItemVariantData
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ShopItemVariantData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ShippingOptions value
     * @return \ArrayType\ArrayOfItemShipping|null
     */
    public function getShippingOptions()
    {
        return $this->ShippingOptions;
    }
    /**
     * Set ShippingOptions value
     * @param \ArrayType\ArrayOfItemShipping $shippingOptions
     * @return \StructType\ShopItemVariantData
     */
    public function setShippingOptions(\ArrayType\ArrayOfItemShipping $shippingOptions = null)
    {
        $this->ShippingOptions = $shippingOptions;
        return $this;
    }
    /**
     * Get PaymentOptionIds value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getPaymentOptionIds()
    {
        return $this->PaymentOptionIds;
    }
    /**
     * Set PaymentOptionIds value
     * @param \ArrayType\ArrayOfInt $paymentOptionIds
     * @return \StructType\ShopItemVariantData
     */
    public function setPaymentOptionIds(\ArrayType\ArrayOfInt $paymentOptionIds = null)
    {
        $this->PaymentOptionIds = $paymentOptionIds;
        return $this;
    }
    /**
     * Get ItemAttributes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getItemAttributes()
    {
        return $this->ItemAttributes;
    }
    /**
     * Set ItemAttributes value
     * @param \ArrayType\ArrayOfInt $itemAttributes
     * @return \StructType\ShopItemVariantData
     */
    public function setItemAttributes(\ArrayType\ArrayOfInt $itemAttributes = null)
    {
        $this->ItemAttributes = $itemAttributes;
        return $this;
    }
    /**
     * Get ShippingCondition value
     * @return string|null
     */
    public function getShippingCondition()
    {
        return $this->ShippingCondition;
    }
    /**
     * Set ShippingCondition value
     * @param string $shippingCondition
     * @return \StructType\ShopItemVariantData
     */
    public function setShippingCondition($shippingCondition = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCondition) && !is_string($shippingCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingCondition, true), gettype($shippingCondition)), __LINE__);
        }
        $this->ShippingCondition = $shippingCondition;
        return $this;
    }
    /**
     * Get PaymentCondition value
     * @return string|null
     */
    public function getPaymentCondition()
    {
        return $this->PaymentCondition;
    }
    /**
     * Set PaymentCondition value
     * @param string $paymentCondition
     * @return \StructType\ShopItemVariantData
     */
    public function setPaymentCondition($paymentCondition = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCondition) && !is_string($paymentCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCondition, true), gettype($paymentCondition)), __LINE__);
        }
        $this->PaymentCondition = $paymentCondition;
        return $this;
    }
    /**
     * Get OwnReferences value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getOwnReferences()
    {
        return $this->OwnReferences;
    }
    /**
     * Set OwnReferences value
     * @param \ArrayType\ArrayOfString $ownReferences
     * @return \StructType\ShopItemVariantData
     */
    public function setOwnReferences(\ArrayType\ArrayOfString $ownReferences = null)
    {
        $this->OwnReferences = $ownReferences;
        return $this;
    }
    /**
     * Get ItemImages value
     * @return \ArrayType\ArrayOfItemImageData|null
     */
    public function getItemImages()
    {
        return $this->ItemImages;
    }
    /**
     * Set ItemImages value
     * @param \ArrayType\ArrayOfItemImageData $itemImages
     * @return \StructType\ShopItemVariantData
     */
    public function setItemImages(\ArrayType\ArrayOfItemImageData $itemImages = null)
    {
        $this->ItemImages = $itemImages;
        return $this;
    }
    /**
     * Get SellerPartNo value
     * @return string|null
     */
    public function getSellerPartNo()
    {
        return $this->SellerPartNo;
    }
    /**
     * Set SellerPartNo value
     * @param string $sellerPartNo
     * @return \StructType\ShopItemVariantData
     */
    public function setSellerPartNo($sellerPartNo = null)
    {
        // validation for constraint: string
        if (!is_null($sellerPartNo) && !is_string($sellerPartNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerPartNo, true), gettype($sellerPartNo)), __LINE__);
        }
        $this->SellerPartNo = $sellerPartNo;
        return $this;
    }
    /**
     * Get VariantData value
     * @return \StructType\VariantData|null
     */
    public function getVariantData()
    {
        return $this->VariantData;
    }
    /**
     * Set VariantData value
     * @param \StructType\VariantData $variantData
     * @return \StructType\ShopItemVariantData
     */
    public function setVariantData(\StructType\VariantData $variantData = null)
    {
        $this->VariantData = $variantData;
        return $this;
    }
    /**
     * Get AttributeValues value
     * @return \StructType\ItemAttributeValues|null
     */
    public function getAttributeValues()
    {
        return $this->AttributeValues;
    }
    /**
     * Set AttributeValues value
     * @param \StructType\ItemAttributeValues $attributeValues
     * @return \StructType\ShopItemVariantData
     */
    public function setAttributeValues(\StructType\ItemAttributeValues $attributeValues = null)
    {
        $this->AttributeValues = $attributeValues;
        return $this;
    }
    /**
     * Get DescriptionLanguageCodeIso2 value
     * @return string|null
     */
    public function getDescriptionLanguageCodeIso2()
    {
        return $this->DescriptionLanguageCodeIso2;
    }
    /**
     * Set DescriptionLanguageCodeIso2 value
     * @param string $descriptionLanguageCodeIso2
     * @return \StructType\ShopItemVariantData
     */
    public function setDescriptionLanguageCodeIso2($descriptionLanguageCodeIso2 = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionLanguageCodeIso2) && !is_string($descriptionLanguageCodeIso2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionLanguageCodeIso2, true), gettype($descriptionLanguageCodeIso2)), __LINE__);
        }
        $this->DescriptionLanguageCodeIso2 = $descriptionLanguageCodeIso2;
        return $this;
    }
}
