<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShopItemData StructType
 * @subpackage Structs
 */
class ShopItemData extends AbstractStructBase
{
    /**
     * The ActivateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ActivateDate;
    /**
     * The AcceptedBuyerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AcceptedBuyerId;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CategoryId;
    /**
     * The DeactivateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeactivateDate;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Price;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The AbsoluteQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AbsoluteQuantity;
    /**
     * The VAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $VAT;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ExternalId;
    /**
     * The ItemAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $ItemAttributes;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PaymentCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCondition;
    /**
     * The ShippingCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCondition;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The ShippingOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItemShipping
     */
    public $ShippingOptions;
    /**
     * The PaymentOptionIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $PaymentOptionIds;
    /**
     * The OwnReferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $OwnReferences;
    /**
     * The ItemImages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItemImageData
     */
    public $ItemImages;
    /**
     * The AttributeValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ItemAttributeValues
     */
    public $AttributeValues;
    /**
     * The DescriptionLanguageCodeIso2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescriptionLanguageCodeIso2;
    /**
     * Constructor method for ShopItemData
     * @uses ShopItemData::setActivateDate()
     * @uses ShopItemData::setAcceptedBuyerId()
     * @uses ShopItemData::setCategoryId()
     * @uses ShopItemData::setDeactivateDate()
     * @uses ShopItemData::setPrice()
     * @uses ShopItemData::setQuantity()
     * @uses ShopItemData::setAbsoluteQuantity()
     * @uses ShopItemData::setVAT()
     * @uses ShopItemData::setExternalId()
     * @uses ShopItemData::setItemAttributes()
     * @uses ShopItemData::setDescription()
     * @uses ShopItemData::setPaymentCondition()
     * @uses ShopItemData::setShippingCondition()
     * @uses ShopItemData::setTitle()
     * @uses ShopItemData::setShippingOptions()
     * @uses ShopItemData::setPaymentOptionIds()
     * @uses ShopItemData::setOwnReferences()
     * @uses ShopItemData::setItemImages()
     * @uses ShopItemData::setAttributeValues()
     * @uses ShopItemData::setDescriptionLanguageCodeIso2()
     * @param string $activateDate
     * @param int $acceptedBuyerId
     * @param int $categoryId
     * @param string $deactivateDate
     * @param int $price
     * @param int $quantity
     * @param int $absoluteQuantity
     * @param int $vAT
     * @param int $externalId
     * @param \ArrayType\ArrayOfInt $itemAttributes
     * @param string $description
     * @param string $paymentCondition
     * @param string $shippingCondition
     * @param string $title
     * @param \ArrayType\ArrayOfItemShipping $shippingOptions
     * @param \ArrayType\ArrayOfInt $paymentOptionIds
     * @param \ArrayType\ArrayOfString $ownReferences
     * @param \ArrayType\ArrayOfItemImageData $itemImages
     * @param \StructType\ItemAttributeValues $attributeValues
     * @param string $descriptionLanguageCodeIso2
     */
    public function __construct($activateDate = null, $acceptedBuyerId = null, $categoryId = null, $deactivateDate = null, $price = null, $quantity = null, $absoluteQuantity = null, $vAT = null, $externalId = null, \ArrayType\ArrayOfInt $itemAttributes = null, $description = null, $paymentCondition = null, $shippingCondition = null, $title = null, \ArrayType\ArrayOfItemShipping $shippingOptions = null, \ArrayType\ArrayOfInt $paymentOptionIds = null, \ArrayType\ArrayOfString $ownReferences = null, \ArrayType\ArrayOfItemImageData $itemImages = null, \StructType\ItemAttributeValues $attributeValues = null, $descriptionLanguageCodeIso2 = null)
    {
        $this
            ->setActivateDate($activateDate)
            ->setAcceptedBuyerId($acceptedBuyerId)
            ->setCategoryId($categoryId)
            ->setDeactivateDate($deactivateDate)
            ->setPrice($price)
            ->setQuantity($quantity)
            ->setAbsoluteQuantity($absoluteQuantity)
            ->setVAT($vAT)
            ->setExternalId($externalId)
            ->setItemAttributes($itemAttributes)
            ->setDescription($description)
            ->setPaymentCondition($paymentCondition)
            ->setShippingCondition($shippingCondition)
            ->setTitle($title)
            ->setShippingOptions($shippingOptions)
            ->setPaymentOptionIds($paymentOptionIds)
            ->setOwnReferences($ownReferences)
            ->setItemImages($itemImages)
            ->setAttributeValues($attributeValues)
            ->setDescriptionLanguageCodeIso2($descriptionLanguageCodeIso2);
    }
    /**
     * Get ActivateDate value
     * @return string
     */
    public function getActivateDate()
    {
        return $this->ActivateDate;
    }
    /**
     * Set ActivateDate value
     * @param string $activateDate
     * @return \StructType\ShopItemData
     */
    public function setActivateDate($activateDate = null)
    {
        // validation for constraint: string
        if (!is_null($activateDate) && !is_string($activateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activateDate, true), gettype($activateDate)), __LINE__);
        }
        $this->ActivateDate = $activateDate;
        return $this;
    }
    /**
     * Get AcceptedBuyerId value
     * @return int
     */
    public function getAcceptedBuyerId()
    {
        return $this->AcceptedBuyerId;
    }
    /**
     * Set AcceptedBuyerId value
     * @param int $acceptedBuyerId
     * @return \StructType\ShopItemData
     */
    public function setAcceptedBuyerId($acceptedBuyerId = null)
    {
        // validation for constraint: int
        if (!is_null($acceptedBuyerId) && !(is_int($acceptedBuyerId) || ctype_digit($acceptedBuyerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($acceptedBuyerId, true), gettype($acceptedBuyerId)), __LINE__);
        }
        $this->AcceptedBuyerId = $acceptedBuyerId;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param int $categoryId
     * @return \StructType\ShopItemData
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get DeactivateDate value
     * @return string
     */
    public function getDeactivateDate()
    {
        return $this->DeactivateDate;
    }
    /**
     * Set DeactivateDate value
     * @param string $deactivateDate
     * @return \StructType\ShopItemData
     */
    public function setDeactivateDate($deactivateDate = null)
    {
        // validation for constraint: string
        if (!is_null($deactivateDate) && !is_string($deactivateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deactivateDate, true), gettype($deactivateDate)), __LINE__);
        }
        $this->DeactivateDate = $deactivateDate;
        return $this;
    }
    /**
     * Get Price value
     * @return int
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param int $price
     * @return \StructType\ShopItemData
     */
    public function setPrice($price = null)
    {
        // validation for constraint: int
        if (!is_null($price) && !(is_int($price) || ctype_digit($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ShopItemData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get AbsoluteQuantity value
     * @return int
     */
    public function getAbsoluteQuantity()
    {
        return $this->AbsoluteQuantity;
    }
    /**
     * Set AbsoluteQuantity value
     * @param int $absoluteQuantity
     * @return \StructType\ShopItemData
     */
    public function setAbsoluteQuantity($absoluteQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($absoluteQuantity) && !(is_int($absoluteQuantity) || ctype_digit($absoluteQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($absoluteQuantity, true), gettype($absoluteQuantity)), __LINE__);
        }
        $this->AbsoluteQuantity = $absoluteQuantity;
        return $this;
    }
    /**
     * Get VAT value
     * @return int
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param int $vAT
     * @return \StructType\ShopItemData
     */
    public function setVAT($vAT = null)
    {
        // validation for constraint: int
        if (!is_null($vAT) && !(is_int($vAT) || ctype_digit($vAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vAT, true), gettype($vAT)), __LINE__);
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get ExternalId value
     * @return int
     */
    public function getExternalId()
    {
        return $this->ExternalId;
    }
    /**
     * Set ExternalId value
     * @param int $externalId
     * @return \StructType\ShopItemData
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: int
        if (!is_null($externalId) && !(is_int($externalId) || ctype_digit($externalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->ExternalId = $externalId;
        return $this;
    }
    /**
     * Get ItemAttributes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getItemAttributes()
    {
        return $this->ItemAttributes;
    }
    /**
     * Set ItemAttributes value
     * @param \ArrayType\ArrayOfInt $itemAttributes
     * @return \StructType\ShopItemData
     */
    public function setItemAttributes(\ArrayType\ArrayOfInt $itemAttributes = null)
    {
        $this->ItemAttributes = $itemAttributes;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ShopItemData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PaymentCondition value
     * @return string|null
     */
    public function getPaymentCondition()
    {
        return $this->PaymentCondition;
    }
    /**
     * Set PaymentCondition value
     * @param string $paymentCondition
     * @return \StructType\ShopItemData
     */
    public function setPaymentCondition($paymentCondition = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCondition) && !is_string($paymentCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCondition, true), gettype($paymentCondition)), __LINE__);
        }
        $this->PaymentCondition = $paymentCondition;
        return $this;
    }
    /**
     * Get ShippingCondition value
     * @return string|null
     */
    public function getShippingCondition()
    {
        return $this->ShippingCondition;
    }
    /**
     * Set ShippingCondition value
     * @param string $shippingCondition
     * @return \StructType\ShopItemData
     */
    public function setShippingCondition($shippingCondition = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCondition) && !is_string($shippingCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingCondition, true), gettype($shippingCondition)), __LINE__);
        }
        $this->ShippingCondition = $shippingCondition;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ShopItemData
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get ShippingOptions value
     * @return \ArrayType\ArrayOfItemShipping|null
     */
    public function getShippingOptions()
    {
        return $this->ShippingOptions;
    }
    /**
     * Set ShippingOptions value
     * @param \ArrayType\ArrayOfItemShipping $shippingOptions
     * @return \StructType\ShopItemData
     */
    public function setShippingOptions(\ArrayType\ArrayOfItemShipping $shippingOptions = null)
    {
        $this->ShippingOptions = $shippingOptions;
        return $this;
    }
    /**
     * Get PaymentOptionIds value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getPaymentOptionIds()
    {
        return $this->PaymentOptionIds;
    }
    /**
     * Set PaymentOptionIds value
     * @param \ArrayType\ArrayOfInt $paymentOptionIds
     * @return \StructType\ShopItemData
     */
    public function setPaymentOptionIds(\ArrayType\ArrayOfInt $paymentOptionIds = null)
    {
        $this->PaymentOptionIds = $paymentOptionIds;
        return $this;
    }
    /**
     * Get OwnReferences value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getOwnReferences()
    {
        return $this->OwnReferences;
    }
    /**
     * Set OwnReferences value
     * @param \ArrayType\ArrayOfString $ownReferences
     * @return \StructType\ShopItemData
     */
    public function setOwnReferences(\ArrayType\ArrayOfString $ownReferences = null)
    {
        $this->OwnReferences = $ownReferences;
        return $this;
    }
    /**
     * Get ItemImages value
     * @return \ArrayType\ArrayOfItemImageData|null
     */
    public function getItemImages()
    {
        return $this->ItemImages;
    }
    /**
     * Set ItemImages value
     * @param \ArrayType\ArrayOfItemImageData $itemImages
     * @return \StructType\ShopItemData
     */
    public function setItemImages(\ArrayType\ArrayOfItemImageData $itemImages = null)
    {
        $this->ItemImages = $itemImages;
        return $this;
    }
    /**
     * Get AttributeValues value
     * @return \StructType\ItemAttributeValues|null
     */
    public function getAttributeValues()
    {
        return $this->AttributeValues;
    }
    /**
     * Set AttributeValues value
     * @param \StructType\ItemAttributeValues $attributeValues
     * @return \StructType\ShopItemData
     */
    public function setAttributeValues(\StructType\ItemAttributeValues $attributeValues = null)
    {
        $this->AttributeValues = $attributeValues;
        return $this;
    }
    /**
     * Get DescriptionLanguageCodeIso2 value
     * @return string|null
     */
    public function getDescriptionLanguageCodeIso2()
    {
        return $this->DescriptionLanguageCodeIso2;
    }
    /**
     * Set DescriptionLanguageCodeIso2 value
     * @param string $descriptionLanguageCodeIso2
     * @return \StructType\ShopItemData
     */
    public function setDescriptionLanguageCodeIso2($descriptionLanguageCodeIso2 = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionLanguageCodeIso2) && !is_string($descriptionLanguageCodeIso2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionLanguageCodeIso2, true), gettype($descriptionLanguageCodeIso2)), __LINE__);
        }
        $this->DescriptionLanguageCodeIso2 = $descriptionLanguageCodeIso2;
        return $this;
    }
}
