<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservedPrice StructType
 * @subpackage Structs
 */
class ReservedPrice extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Price;
    /**
     * Constructor method for ReservedPrice
     * @uses ReservedPrice::setPrice()
     * @param int $price
     */
    public function __construct($price = null)
    {
        $this
            ->setPrice($price);
    }
    /**
     * Get Price value
     * @return int
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param int $price
     * @return \StructType\ReservedPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: int
        if (!is_null($price) && !(is_int($price) || ctype_digit($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
}
