<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueuedRequestResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueuedRequestResponse
 * @subpackage Structs
 */
class QueuedRequestResponse extends AbstractStructBase
{
    /**
     * The RequestId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RequestId;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * Constructor method for QueuedRequestResponse
     * @uses QueuedRequestResponse::setRequestId()
     * @uses QueuedRequestResponse::setItemId()
     * @param int $requestId
     * @param int $itemId
     */
    public function __construct($requestId = null, $itemId = null)
    {
        $this
            ->setRequestId($requestId)
            ->setItemId($itemId);
    }
    /**
     * Get RequestId value
     * @return int
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param int $requestId
     * @return \StructType\QueuedRequestResponse
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !(is_int($requestId) || ctype_digit($requestId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \StructType\QueuedRequestResponse
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
}
