<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Item
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The StartQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StartQuantity;
    /**
     * The RemainingQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RemainingQuantity;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ItemType;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The VAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $VAT;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategoryId;
    /**
     * The ReservePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReservePrice;
    /**
     * The ReservePriceReached
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ReservePriceReached;
    /**
     * The AcceptsPickup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AcceptsPickup;
    /**
     * The TotalBids
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalBids;
    /**
     * The Bold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Bold;
    /**
     * The Thumbnail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Thumbnail;
    /**
     * The Highlight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Highlight;
    /**
     * The FeaturedItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FeaturedItem;
    /**
     * The AcceptedBuyerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AcceptedBuyerId;
    /**
     * The Paypal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Paypal;
    /**
     * The PaymentTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTypeId;
    /**
     * The ShippingOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemShipping[]
     */
    public $ShippingOptions;
    /**
     * The PaymentOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $PaymentOptions;
    /**
     * The ImageLinks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ImageLinks;
    /**
     * The Buyers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\User[]
     */
    public $Buyers;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ItemStatus
     */
    public $Status;
    /**
     * The DetailedImageLinks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ImageLink[]
     */
    public $DetailedImageLinks;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortDescription;
    /**
     * The OwnReferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $OwnReferences;
    /**
     * The AttributeValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributeValues
     */
    public $AttributeValues;
    /**
     * The ItemAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $ItemAttributes;
    /**
     * The LongDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LongDescription;
    /**
     * The OpeningBid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OpeningBid;
    /**
     * The BuyItNowPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BuyItNowPrice;
    /**
     * The NextBid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NextBid;
    /**
     * The PaymentCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCondition;
    /**
     * The ShippingCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCondition;
    /**
     * The MaxBid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MaxBid;
    /**
     * The ItemLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemLink;
    /**
     * The ThumbnailLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThumbnailLink;
    /**
     * The Seller
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\User
     */
    public $Seller;
    /**
     * The MaxBidder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\User
     */
    public $MaxBidder;
    /**
     * Constructor method for Item
     * @uses Item::setStartQuantity()
     * @uses Item::setRemainingQuantity()
     * @uses Item::setItemType()
     * @uses Item::setId()
     * @uses Item::setVAT()
     * @uses Item::setStartDate()
     * @uses Item::setEndDate()
     * @uses Item::setCategoryId()
     * @uses Item::setReservePrice()
     * @uses Item::setReservePriceReached()
     * @uses Item::setAcceptsPickup()
     * @uses Item::setTotalBids()
     * @uses Item::setBold()
     * @uses Item::setThumbnail()
     * @uses Item::setHighlight()
     * @uses Item::setFeaturedItem()
     * @uses Item::setAcceptedBuyerId()
     * @uses Item::setPaypal()
     * @uses Item::setPaymentTypeId()
     * @uses Item::setShippingOptions()
     * @uses Item::setPaymentOptions()
     * @uses Item::setImageLinks()
     * @uses Item::setBuyers()
     * @uses Item::setStatus()
     * @uses Item::setDetailedImageLinks()
     * @uses Item::setShortDescription()
     * @uses Item::setOwnReferences()
     * @uses Item::setAttributeValues()
     * @uses Item::setItemAttributes()
     * @uses Item::setLongDescription()
     * @uses Item::setOpeningBid()
     * @uses Item::setBuyItNowPrice()
     * @uses Item::setNextBid()
     * @uses Item::setPaymentCondition()
     * @uses Item::setShippingCondition()
     * @uses Item::setMaxBid()
     * @uses Item::setItemLink()
     * @uses Item::setThumbnailLink()
     * @uses Item::setSeller()
     * @uses Item::setMaxBidder()
     * @param int $startQuantity
     * @param int $remainingQuantity
     * @param string $itemType
     * @param int $id
     * @param int $vAT
     * @param string $startDate
     * @param string $endDate
     * @param int $categoryId
     * @param int $reservePrice
     * @param bool $reservePriceReached
     * @param bool $acceptsPickup
     * @param int $totalBids
     * @param bool $bold
     * @param bool $thumbnail
     * @param bool $highlight
     * @param bool $featuredItem
     * @param int $acceptedBuyerId
     * @param bool $paypal
     * @param int $paymentTypeId
     * @param \StructType\ItemShipping[] $shippingOptions
     * @param \ArrayType\ArrayOfInt $paymentOptions
     * @param \ArrayType\ArrayOfString $imageLinks
     * @param \StructType\User[] $buyers
     * @param \StructType\ItemStatus $status
     * @param \StructType\ImageLink[] $detailedImageLinks
     * @param string $shortDescription
     * @param \ArrayType\ArrayOfString $ownReferences
     * @param \StructType\AttributeValues $attributeValues
     * @param \ArrayType\ArrayOfInt $itemAttributes
     * @param string $longDescription
     * @param int $openingBid
     * @param int $buyItNowPrice
     * @param int $nextBid
     * @param string $paymentCondition
     * @param string $shippingCondition
     * @param int $maxBid
     * @param string $itemLink
     * @param string $thumbnailLink
     * @param \StructType\User $seller
     * @param \StructType\User $maxBidder
     */
    public function __construct($startQuantity = null, $remainingQuantity = null, $itemType = null, $id = null, $vAT = null, $startDate = null, $endDate = null, $categoryId = null, $reservePrice = null, $reservePriceReached = null, $acceptsPickup = null, $totalBids = null, $bold = null, $thumbnail = null, $highlight = null, $featuredItem = null, $acceptedBuyerId = null, $paypal = null, $paymentTypeId = null, array $shippingOptions = array(), \ArrayType\ArrayOfInt $paymentOptions = null, \ArrayType\ArrayOfString $imageLinks = null, array $buyers = array(), \StructType\ItemStatus $status = null, array $detailedImageLinks = array(), $shortDescription = null, \ArrayType\ArrayOfString $ownReferences = null, \StructType\AttributeValues $attributeValues = null, \ArrayType\ArrayOfInt $itemAttributes = null, $longDescription = null, $openingBid = null, $buyItNowPrice = null, $nextBid = null, $paymentCondition = null, $shippingCondition = null, $maxBid = null, $itemLink = null, $thumbnailLink = null, \StructType\User $seller = null, \StructType\User $maxBidder = null)
    {
        $this
            ->setStartQuantity($startQuantity)
            ->setRemainingQuantity($remainingQuantity)
            ->setItemType($itemType)
            ->setId($id)
            ->setVAT($vAT)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCategoryId($categoryId)
            ->setReservePrice($reservePrice)
            ->setReservePriceReached($reservePriceReached)
            ->setAcceptsPickup($acceptsPickup)
            ->setTotalBids($totalBids)
            ->setBold($bold)
            ->setThumbnail($thumbnail)
            ->setHighlight($highlight)
            ->setFeaturedItem($featuredItem)
            ->setAcceptedBuyerId($acceptedBuyerId)
            ->setPaypal($paypal)
            ->setPaymentTypeId($paymentTypeId)
            ->setShippingOptions($shippingOptions)
            ->setPaymentOptions($paymentOptions)
            ->setImageLinks($imageLinks)
            ->setBuyers($buyers)
            ->setStatus($status)
            ->setDetailedImageLinks($detailedImageLinks)
            ->setShortDescription($shortDescription)
            ->setOwnReferences($ownReferences)
            ->setAttributeValues($attributeValues)
            ->setItemAttributes($itemAttributes)
            ->setLongDescription($longDescription)
            ->setOpeningBid($openingBid)
            ->setBuyItNowPrice($buyItNowPrice)
            ->setNextBid($nextBid)
            ->setPaymentCondition($paymentCondition)
            ->setShippingCondition($shippingCondition)
            ->setMaxBid($maxBid)
            ->setItemLink($itemLink)
            ->setThumbnailLink($thumbnailLink)
            ->setSeller($seller)
            ->setMaxBidder($maxBidder);
    }
    /**
     * Get StartQuantity value
     * @return int
     */
    public function getStartQuantity()
    {
        return $this->StartQuantity;
    }
    /**
     * Set StartQuantity value
     * @param int $startQuantity
     * @return \StructType\Item
     */
    public function setStartQuantity($startQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($startQuantity) && !(is_int($startQuantity) || ctype_digit($startQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startQuantity, true), gettype($startQuantity)), __LINE__);
        }
        $this->StartQuantity = $startQuantity;
        return $this;
    }
    /**
     * Get RemainingQuantity value
     * @return int
     */
    public function getRemainingQuantity()
    {
        return $this->RemainingQuantity;
    }
    /**
     * Set RemainingQuantity value
     * @param int $remainingQuantity
     * @return \StructType\Item
     */
    public function setRemainingQuantity($remainingQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($remainingQuantity) && !(is_int($remainingQuantity) || ctype_digit($remainingQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remainingQuantity, true), gettype($remainingQuantity)), __LINE__);
        }
        $this->RemainingQuantity = $remainingQuantity;
        return $this;
    }
    /**
     * Get ItemType value
     * @return string
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @uses \EnumType\ItemType::valueIsValid()
     * @uses \EnumType\ItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \StructType\Item
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemType::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemType', is_array($itemType) ? implode(', ', $itemType) : var_export($itemType, true), implode(', ', \EnumType\ItemType::getValidValues())), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Item
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get VAT value
     * @return int
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param int $vAT
     * @return \StructType\Item
     */
    public function setVAT($vAT = null)
    {
        // validation for constraint: int
        if (!is_null($vAT) && !(is_int($vAT) || ctype_digit($vAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vAT, true), gettype($vAT)), __LINE__);
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Item
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Item
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param int $categoryId
     * @return \StructType\Item
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get ReservePrice value
     * @return int
     */
    public function getReservePrice()
    {
        return $this->ReservePrice;
    }
    /**
     * Set ReservePrice value
     * @param int $reservePrice
     * @return \StructType\Item
     */
    public function setReservePrice($reservePrice = null)
    {
        // validation for constraint: int
        if (!is_null($reservePrice) && !(is_int($reservePrice) || ctype_digit($reservePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservePrice, true), gettype($reservePrice)), __LINE__);
        }
        $this->ReservePrice = $reservePrice;
        return $this;
    }
    /**
     * Get ReservePriceReached value
     * @return bool
     */
    public function getReservePriceReached()
    {
        return $this->ReservePriceReached;
    }
    /**
     * Set ReservePriceReached value
     * @param bool $reservePriceReached
     * @return \StructType\Item
     */
    public function setReservePriceReached($reservePriceReached = null)
    {
        // validation for constraint: boolean
        if (!is_null($reservePriceReached) && !is_bool($reservePriceReached)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reservePriceReached, true), gettype($reservePriceReached)), __LINE__);
        }
        $this->ReservePriceReached = $reservePriceReached;
        return $this;
    }
    /**
     * Get AcceptsPickup value
     * @return bool
     */
    public function getAcceptsPickup()
    {
        return $this->AcceptsPickup;
    }
    /**
     * Set AcceptsPickup value
     * @param bool $acceptsPickup
     * @return \StructType\Item
     */
    public function setAcceptsPickup($acceptsPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptsPickup) && !is_bool($acceptsPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acceptsPickup, true), gettype($acceptsPickup)), __LINE__);
        }
        $this->AcceptsPickup = $acceptsPickup;
        return $this;
    }
    /**
     * Get TotalBids value
     * @return int
     */
    public function getTotalBids()
    {
        return $this->TotalBids;
    }
    /**
     * Set TotalBids value
     * @param int $totalBids
     * @return \StructType\Item
     */
    public function setTotalBids($totalBids = null)
    {
        // validation for constraint: int
        if (!is_null($totalBids) && !(is_int($totalBids) || ctype_digit($totalBids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalBids, true), gettype($totalBids)), __LINE__);
        }
        $this->TotalBids = $totalBids;
        return $this;
    }
    /**
     * Get Bold value
     * @return bool
     */
    public function getBold()
    {
        return $this->Bold;
    }
    /**
     * Set Bold value
     * @param bool $bold
     * @return \StructType\Item
     */
    public function setBold($bold = null)
    {
        // validation for constraint: boolean
        if (!is_null($bold) && !is_bool($bold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bold, true), gettype($bold)), __LINE__);
        }
        $this->Bold = $bold;
        return $this;
    }
    /**
     * Get Thumbnail value
     * @return bool
     */
    public function getThumbnail()
    {
        return $this->Thumbnail;
    }
    /**
     * Set Thumbnail value
     * @param bool $thumbnail
     * @return \StructType\Item
     */
    public function setThumbnail($thumbnail = null)
    {
        // validation for constraint: boolean
        if (!is_null($thumbnail) && !is_bool($thumbnail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thumbnail, true), gettype($thumbnail)), __LINE__);
        }
        $this->Thumbnail = $thumbnail;
        return $this;
    }
    /**
     * Get Highlight value
     * @return bool
     */
    public function getHighlight()
    {
        return $this->Highlight;
    }
    /**
     * Set Highlight value
     * @param bool $highlight
     * @return \StructType\Item
     */
    public function setHighlight($highlight = null)
    {
        // validation for constraint: boolean
        if (!is_null($highlight) && !is_bool($highlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($highlight, true), gettype($highlight)), __LINE__);
        }
        $this->Highlight = $highlight;
        return $this;
    }
    /**
     * Get FeaturedItem value
     * @return bool
     */
    public function getFeaturedItem()
    {
        return $this->FeaturedItem;
    }
    /**
     * Set FeaturedItem value
     * @param bool $featuredItem
     * @return \StructType\Item
     */
    public function setFeaturedItem($featuredItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($featuredItem) && !is_bool($featuredItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($featuredItem, true), gettype($featuredItem)), __LINE__);
        }
        $this->FeaturedItem = $featuredItem;
        return $this;
    }
    /**
     * Get AcceptedBuyerId value
     * @return int
     */
    public function getAcceptedBuyerId()
    {
        return $this->AcceptedBuyerId;
    }
    /**
     * Set AcceptedBuyerId value
     * @param int $acceptedBuyerId
     * @return \StructType\Item
     */
    public function setAcceptedBuyerId($acceptedBuyerId = null)
    {
        // validation for constraint: int
        if (!is_null($acceptedBuyerId) && !(is_int($acceptedBuyerId) || ctype_digit($acceptedBuyerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($acceptedBuyerId, true), gettype($acceptedBuyerId)), __LINE__);
        }
        $this->AcceptedBuyerId = $acceptedBuyerId;
        return $this;
    }
    /**
     * Get Paypal value
     * @return bool
     */
    public function getPaypal()
    {
        return $this->Paypal;
    }
    /**
     * Set Paypal value
     * @param bool $paypal
     * @return \StructType\Item
     */
    public function setPaypal($paypal = null)
    {
        // validation for constraint: boolean
        if (!is_null($paypal) && !is_bool($paypal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paypal, true), gettype($paypal)), __LINE__);
        }
        $this->Paypal = $paypal;
        return $this;
    }
    /**
     * Get PaymentTypeId value
     * @return int
     */
    public function getPaymentTypeId()
    {
        return $this->PaymentTypeId;
    }
    /**
     * Set PaymentTypeId value
     * @param int $paymentTypeId
     * @return \StructType\Item
     */
    public function setPaymentTypeId($paymentTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTypeId) && !(is_int($paymentTypeId) || ctype_digit($paymentTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentTypeId, true), gettype($paymentTypeId)), __LINE__);
        }
        $this->PaymentTypeId = $paymentTypeId;
        return $this;
    }
    /**
     * Get ShippingOptions value
     * @return \StructType\ItemShipping[]|null
     */
    public function getShippingOptions()
    {
        return $this->ShippingOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setShippingOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShippingOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShippingOptionsForArrayConstraintsFromSetShippingOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemShippingOptionsItem) {
            // validation for constraint: itemType
            if (!$itemShippingOptionsItem instanceof \StructType\ItemShipping) {
                $invalidValues[] = is_object($itemShippingOptionsItem) ? get_class($itemShippingOptionsItem) : sprintf('%s(%s)', gettype($itemShippingOptionsItem), var_export($itemShippingOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShippingOptions property can only contain items of type \StructType\ItemShipping, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShippingOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemShipping[] $shippingOptions
     * @return \StructType\Item
     */
    public function setShippingOptions(array $shippingOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($shippingOptionsArrayErrorMessage = self::validateShippingOptionsForArrayConstraintsFromSetShippingOptions($shippingOptions))) {
            throw new \InvalidArgumentException($shippingOptionsArrayErrorMessage, __LINE__);
        }
        $this->ShippingOptions = $shippingOptions;
        return $this;
    }
    /**
     * Add item to ShippingOptions value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemShipping $item
     * @return \StructType\Item
     */
    public function addToShippingOptions(\StructType\ItemShipping $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemShipping) {
            throw new \InvalidArgumentException(sprintf('The ShippingOptions property can only contain items of type \StructType\ItemShipping, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShippingOptions[] = $item;
        return $this;
    }
    /**
     * Get PaymentOptions value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getPaymentOptions()
    {
        return $this->PaymentOptions;
    }
    /**
     * Set PaymentOptions value
     * @param \ArrayType\ArrayOfInt $paymentOptions
     * @return \StructType\Item
     */
    public function setPaymentOptions(\ArrayType\ArrayOfInt $paymentOptions = null)
    {
        $this->PaymentOptions = $paymentOptions;
        return $this;
    }
    /**
     * Get ImageLinks value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getImageLinks()
    {
        return $this->ImageLinks;
    }
    /**
     * Set ImageLinks value
     * @param \ArrayType\ArrayOfString $imageLinks
     * @return \StructType\Item
     */
    public function setImageLinks(\ArrayType\ArrayOfString $imageLinks = null)
    {
        $this->ImageLinks = $imageLinks;
        return $this;
    }
    /**
     * Get Buyers value
     * @return \StructType\User[]|null
     */
    public function getBuyers()
    {
        return $this->Buyers;
    }
    /**
     * This method is responsible for validating the values passed to the setBuyers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBuyers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBuyersForArrayConstraintsFromSetBuyers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemBuyersItem) {
            // validation for constraint: itemType
            if (!$itemBuyersItem instanceof \StructType\User) {
                $invalidValues[] = is_object($itemBuyersItem) ? get_class($itemBuyersItem) : sprintf('%s(%s)', gettype($itemBuyersItem), var_export($itemBuyersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Buyers property can only contain items of type \StructType\User, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Buyers value
     * @throws \InvalidArgumentException
     * @param \StructType\User[] $buyers
     * @return \StructType\Item
     */
    public function setBuyers(array $buyers = array())
    {
        // validation for constraint: array
        if ('' !== ($buyersArrayErrorMessage = self::validateBuyersForArrayConstraintsFromSetBuyers($buyers))) {
            throw new \InvalidArgumentException($buyersArrayErrorMessage, __LINE__);
        }
        $this->Buyers = $buyers;
        return $this;
    }
    /**
     * Add item to Buyers value
     * @throws \InvalidArgumentException
     * @param \StructType\User $item
     * @return \StructType\Item
     */
    public function addToBuyers(\StructType\User $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\User) {
            throw new \InvalidArgumentException(sprintf('The Buyers property can only contain items of type \StructType\User, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Buyers[] = $item;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\ItemStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\ItemStatus $status
     * @return \StructType\Item
     */
    public function setStatus(\StructType\ItemStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DetailedImageLinks value
     * @return \StructType\ImageLink[]|null
     */
    public function getDetailedImageLinks()
    {
        return $this->DetailedImageLinks;
    }
    /**
     * This method is responsible for validating the values passed to the setDetailedImageLinks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetailedImageLinks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailedImageLinksForArrayConstraintsFromSetDetailedImageLinks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDetailedImageLinksItem) {
            // validation for constraint: itemType
            if (!$itemDetailedImageLinksItem instanceof \StructType\ImageLink) {
                $invalidValues[] = is_object($itemDetailedImageLinksItem) ? get_class($itemDetailedImageLinksItem) : sprintf('%s(%s)', gettype($itemDetailedImageLinksItem), var_export($itemDetailedImageLinksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DetailedImageLinks property can only contain items of type \StructType\ImageLink, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DetailedImageLinks value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageLink[] $detailedImageLinks
     * @return \StructType\Item
     */
    public function setDetailedImageLinks(array $detailedImageLinks = array())
    {
        // validation for constraint: array
        if ('' !== ($detailedImageLinksArrayErrorMessage = self::validateDetailedImageLinksForArrayConstraintsFromSetDetailedImageLinks($detailedImageLinks))) {
            throw new \InvalidArgumentException($detailedImageLinksArrayErrorMessage, __LINE__);
        }
        $this->DetailedImageLinks = $detailedImageLinks;
        return $this;
    }
    /**
     * Add item to DetailedImageLinks value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageLink $item
     * @return \StructType\Item
     */
    public function addToDetailedImageLinks(\StructType\ImageLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImageLink) {
            throw new \InvalidArgumentException(sprintf('The DetailedImageLinks property can only contain items of type \StructType\ImageLink, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DetailedImageLinks[] = $item;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param string $shortDescription
     * @return \StructType\Item
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get OwnReferences value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getOwnReferences()
    {
        return $this->OwnReferences;
    }
    /**
     * Set OwnReferences value
     * @param \ArrayType\ArrayOfString $ownReferences
     * @return \StructType\Item
     */
    public function setOwnReferences(\ArrayType\ArrayOfString $ownReferences = null)
    {
        $this->OwnReferences = $ownReferences;
        return $this;
    }
    /**
     * Get AttributeValues value
     * @return \StructType\AttributeValues|null
     */
    public function getAttributeValues()
    {
        return $this->AttributeValues;
    }
    /**
     * Set AttributeValues value
     * @param \StructType\AttributeValues $attributeValues
     * @return \StructType\Item
     */
    public function setAttributeValues(\StructType\AttributeValues $attributeValues = null)
    {
        $this->AttributeValues = $attributeValues;
        return $this;
    }
    /**
     * Get ItemAttributes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getItemAttributes()
    {
        return $this->ItemAttributes;
    }
    /**
     * Set ItemAttributes value
     * @param \ArrayType\ArrayOfInt $itemAttributes
     * @return \StructType\Item
     */
    public function setItemAttributes(\ArrayType\ArrayOfInt $itemAttributes = null)
    {
        $this->ItemAttributes = $itemAttributes;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * Set LongDescription value
     * @param string $longDescription
     * @return \StructType\Item
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longDescription, true), gettype($longDescription)), __LINE__);
        }
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Get OpeningBid value
     * @return int|null
     */
    public function getOpeningBid()
    {
        return $this->OpeningBid;
    }
    /**
     * Set OpeningBid value
     * @param int $openingBid
     * @return \StructType\Item
     */
    public function setOpeningBid($openingBid = null)
    {
        // validation for constraint: int
        if (!is_null($openingBid) && !(is_int($openingBid) || ctype_digit($openingBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openingBid, true), gettype($openingBid)), __LINE__);
        }
        $this->OpeningBid = $openingBid;
        return $this;
    }
    /**
     * Get BuyItNowPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBuyItNowPrice()
    {
        return isset($this->BuyItNowPrice) ? $this->BuyItNowPrice : null;
    }
    /**
     * Set BuyItNowPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $buyItNowPrice
     * @return \StructType\Item
     */
    public function setBuyItNowPrice($buyItNowPrice = null)
    {
        // validation for constraint: int
        if (!is_null($buyItNowPrice) && !(is_int($buyItNowPrice) || ctype_digit($buyItNowPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($buyItNowPrice, true), gettype($buyItNowPrice)), __LINE__);
        }
        if (is_null($buyItNowPrice) || (is_array($buyItNowPrice) && empty($buyItNowPrice))) {
            unset($this->BuyItNowPrice);
        } else {
            $this->BuyItNowPrice = $buyItNowPrice;
        }
        return $this;
    }
    /**
     * Get NextBid value
     * @return int|null
     */
    public function getNextBid()
    {
        return $this->NextBid;
    }
    /**
     * Set NextBid value
     * @param int $nextBid
     * @return \StructType\Item
     */
    public function setNextBid($nextBid = null)
    {
        // validation for constraint: int
        if (!is_null($nextBid) && !(is_int($nextBid) || ctype_digit($nextBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextBid, true), gettype($nextBid)), __LINE__);
        }
        $this->NextBid = $nextBid;
        return $this;
    }
    /**
     * Get PaymentCondition value
     * @return string|null
     */
    public function getPaymentCondition()
    {
        return $this->PaymentCondition;
    }
    /**
     * Set PaymentCondition value
     * @param string $paymentCondition
     * @return \StructType\Item
     */
    public function setPaymentCondition($paymentCondition = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCondition) && !is_string($paymentCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCondition, true), gettype($paymentCondition)), __LINE__);
        }
        $this->PaymentCondition = $paymentCondition;
        return $this;
    }
    /**
     * Get ShippingCondition value
     * @return string|null
     */
    public function getShippingCondition()
    {
        return $this->ShippingCondition;
    }
    /**
     * Set ShippingCondition value
     * @param string $shippingCondition
     * @return \StructType\Item
     */
    public function setShippingCondition($shippingCondition = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCondition) && !is_string($shippingCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingCondition, true), gettype($shippingCondition)), __LINE__);
        }
        $this->ShippingCondition = $shippingCondition;
        return $this;
    }
    /**
     * Get MaxBid value
     * @return int|null
     */
    public function getMaxBid()
    {
        return $this->MaxBid;
    }
    /**
     * Set MaxBid value
     * @param int $maxBid
     * @return \StructType\Item
     */
    public function setMaxBid($maxBid = null)
    {
        // validation for constraint: int
        if (!is_null($maxBid) && !(is_int($maxBid) || ctype_digit($maxBid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxBid, true), gettype($maxBid)), __LINE__);
        }
        $this->MaxBid = $maxBid;
        return $this;
    }
    /**
     * Get ItemLink value
     * @return string|null
     */
    public function getItemLink()
    {
        return $this->ItemLink;
    }
    /**
     * Set ItemLink value
     * @param string $itemLink
     * @return \StructType\Item
     */
    public function setItemLink($itemLink = null)
    {
        // validation for constraint: string
        if (!is_null($itemLink) && !is_string($itemLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemLink, true), gettype($itemLink)), __LINE__);
        }
        $this->ItemLink = $itemLink;
        return $this;
    }
    /**
     * Get ThumbnailLink value
     * @return string|null
     */
    public function getThumbnailLink()
    {
        return $this->ThumbnailLink;
    }
    /**
     * Set ThumbnailLink value
     * @param string $thumbnailLink
     * @return \StructType\Item
     */
    public function setThumbnailLink($thumbnailLink = null)
    {
        // validation for constraint: string
        if (!is_null($thumbnailLink) && !is_string($thumbnailLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thumbnailLink, true), gettype($thumbnailLink)), __LINE__);
        }
        $this->ThumbnailLink = $thumbnailLink;
        return $this;
    }
    /**
     * Get Seller value
     * @return \StructType\User|null
     */
    public function getSeller()
    {
        return $this->Seller;
    }
    /**
     * Set Seller value
     * @param \StructType\User $seller
     * @return \StructType\Item
     */
    public function setSeller(\StructType\User $seller = null)
    {
        $this->Seller = $seller;
        return $this;
    }
    /**
     * Get MaxBidder value
     * @return \StructType\User|null
     */
    public function getMaxBidder()
    {
        return $this->MaxBidder;
    }
    /**
     * Set MaxBidder value
     * @param \StructType\User $maxBidder
     * @return \StructType\Item
     */
    public function setMaxBidder(\StructType\User $maxBidder = null)
    {
        $this->MaxBidder = $maxBidder;
        return $this;
    }
}
