<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSellerItems StructType
 * @subpackage Structs
 */
class GetSellerItems extends AbstractStructBase
{
    /**
     * The categoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $categoryId;
    /**
     * The filterActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $filterActive;
    /**
     * The minEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $minEndDate;
    /**
     * The maxEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $maxEndDate;
    /**
     * The filterItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $filterItemType;
    /**
     * Constructor method for GetSellerItems
     * @uses GetSellerItems::setCategoryId()
     * @uses GetSellerItems::setFilterActive()
     * @uses GetSellerItems::setMinEndDate()
     * @uses GetSellerItems::setMaxEndDate()
     * @uses GetSellerItems::setFilterItemType()
     * @param int $categoryId
     * @param string $filterActive
     * @param string $minEndDate
     * @param string $maxEndDate
     * @param string $filterItemType
     */
    public function __construct($categoryId = null, $filterActive = null, $minEndDate = null, $maxEndDate = null, $filterItemType = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setFilterActive($filterActive)
            ->setMinEndDate($minEndDate)
            ->setMaxEndDate($maxEndDate)
            ->setFilterItemType($filterItemType);
    }
    /**
     * Get categoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->categoryId;
    }
    /**
     * Set categoryId value
     * @param int $categoryId
     * @return \StructType\GetSellerItems
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->categoryId = $categoryId;
        return $this;
    }
    /**
     * Get filterActive value
     * @return string
     */
    public function getFilterActive()
    {
        return $this->filterActive;
    }
    /**
     * Set filterActive value
     * @uses \EnumType\ActiveFilter::valueIsValid()
     * @uses \EnumType\ActiveFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $filterActive
     * @return \StructType\GetSellerItems
     */
    public function setFilterActive($filterActive = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActiveFilter::valueIsValid($filterActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActiveFilter', is_array($filterActive) ? implode(', ', $filterActive) : var_export($filterActive, true), implode(', ', \EnumType\ActiveFilter::getValidValues())), __LINE__);
        }
        $this->filterActive = $filterActive;
        return $this;
    }
    /**
     * Get minEndDate value
     * @return string
     */
    public function getMinEndDate()
    {
        return $this->minEndDate;
    }
    /**
     * Set minEndDate value
     * @param string $minEndDate
     * @return \StructType\GetSellerItems
     */
    public function setMinEndDate($minEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($minEndDate) && !is_string($minEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minEndDate, true), gettype($minEndDate)), __LINE__);
        }
        $this->minEndDate = $minEndDate;
        return $this;
    }
    /**
     * Get maxEndDate value
     * @return string
     */
    public function getMaxEndDate()
    {
        return $this->maxEndDate;
    }
    /**
     * Set maxEndDate value
     * @param string $maxEndDate
     * @return \StructType\GetSellerItems
     */
    public function setMaxEndDate($maxEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxEndDate) && !is_string($maxEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxEndDate, true), gettype($maxEndDate)), __LINE__);
        }
        $this->maxEndDate = $maxEndDate;
        return $this;
    }
    /**
     * Get filterItemType value
     * @return string
     */
    public function getFilterItemType()
    {
        return $this->filterItemType;
    }
    /**
     * Set filterItemType value
     * @uses \EnumType\ItemTypeFilter::valueIsValid()
     * @uses \EnumType\ItemTypeFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $filterItemType
     * @return \StructType\GetSellerItems
     */
    public function setFilterItemType($filterItemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemTypeFilter::valueIsValid($filterItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemTypeFilter', is_array($filterItemType) ? implode(', ', $filterItemType) : var_export($filterItemType, true), implode(', ', \EnumType\ItemTypeFilter::getValidValues())), __LINE__);
        }
        $this->filterItemType = $filterItemType;
        return $this;
    }
}
