<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the AuthenticationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthenticationHeader $authenticationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthenticationHeader(\StructType\AuthenticationHeader $authenticationHeader, $nameSpace = 'http://api.tradera.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthenticationHeader', $authenticationHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the AuthorizationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthorizationHeader $authorizationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthorizationHeader(\StructType\AuthorizationHeader $authorizationHeader, $nameSpace = 'http://api.tradera.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthorizationHeader', $authorizationHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the ConfigurationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ConfigurationHeader $configurationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderConfigurationHeader(\StructType\ConfigurationHeader $configurationHeader, $nameSpace = 'http://api.tradera.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ConfigurationHeader', $configurationHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdateShopItem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateShopItem $parameters
     * @return \StructType\UpdateShopItemResponse|bool
     */
    public function UpdateShopItem(\StructType\UpdateShopItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateShopItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateShopItemVariant
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateShopItemVariant $parameters
     * @return \StructType\UpdateShopItemVariantResponse|bool
     */
    public function UpdateShopItemVariant(\StructType\UpdateShopItemVariant $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateShopItemVariant($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateTransactionStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthenticationHeader, AuthorizationHeader, ConfigurationHeader
     * - SOAPHeaderNamespaces: http://api.tradera.com, http://api.tradera.com, http://api.tradera.com
     * - SOAPHeaderTypes: \StructType\AuthenticationHeader, \StructType\AuthorizationHeader, \StructType\ConfigurationHeader
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTransactionStatus $parameters
     * @return \StructType\UpdateTransactionStatusResponse|bool
     */
    public function UpdateTransactionStatus(\StructType\UpdateTransactionStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTransactionStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateShopItemResponse|\StructType\UpdateShopItemVariantResponse|\StructType\UpdateTransactionStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
