<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUpdatedItemInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfUpdatedItemInfo extends AbstractStructArrayBase
{
    /**
     * The UpdatedItemInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UpdatedItemInfo[]
     */
    public $UpdatedItemInfo;
    /**
     * Constructor method for ArrayOfUpdatedItemInfo
     * @uses ArrayOfUpdatedItemInfo::setUpdatedItemInfo()
     * @param \StructType\UpdatedItemInfo[] $updatedItemInfo
     */
    public function __construct(array $updatedItemInfo = array())
    {
        $this
            ->setUpdatedItemInfo($updatedItemInfo);
    }
    /**
     * Get UpdatedItemInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UpdatedItemInfo[]|null
     */
    public function getUpdatedItemInfo()
    {
        return isset($this->UpdatedItemInfo) ? $this->UpdatedItemInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUpdatedItemInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUpdatedItemInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUpdatedItemInfoForArrayConstraintsFromSetUpdatedItemInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfUpdatedItemInfoUpdatedItemInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfUpdatedItemInfoUpdatedItemInfoItem instanceof \StructType\UpdatedItemInfo) {
                $invalidValues[] = is_object($arrayOfUpdatedItemInfoUpdatedItemInfoItem) ? get_class($arrayOfUpdatedItemInfoUpdatedItemInfoItem) : sprintf('%s(%s)', gettype($arrayOfUpdatedItemInfoUpdatedItemInfoItem), var_export($arrayOfUpdatedItemInfoUpdatedItemInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UpdatedItemInfo property can only contain items of type \StructType\UpdatedItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UpdatedItemInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UpdatedItemInfo[] $updatedItemInfo
     * @return \ArrayType\ArrayOfUpdatedItemInfo
     */
    public function setUpdatedItemInfo(array $updatedItemInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($updatedItemInfoArrayErrorMessage = self::validateUpdatedItemInfoForArrayConstraintsFromSetUpdatedItemInfo($updatedItemInfo))) {
            throw new \InvalidArgumentException($updatedItemInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($updatedItemInfo) || (is_array($updatedItemInfo) && empty($updatedItemInfo))) {
            unset($this->UpdatedItemInfo);
        } else {
            $this->UpdatedItemInfo = $updatedItemInfo;
        }
        return $this;
    }
    /**
     * Add item to UpdatedItemInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\UpdatedItemInfo $item
     * @return \ArrayType\ArrayOfUpdatedItemInfo
     */
    public function addToUpdatedItemInfo(\StructType\UpdatedItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UpdatedItemInfo) {
            throw new \InvalidArgumentException(sprintf('The UpdatedItemInfo property can only contain items of type \StructType\UpdatedItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UpdatedItemInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\UpdatedItemInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\UpdatedItemInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\UpdatedItemInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\UpdatedItemInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\UpdatedItemInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UpdatedItemInfo
     */
    public function getAttributeName()
    {
        return 'UpdatedItemInfo';
    }
}
