<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Specification StructType
 * @subpackage Structs
 */
class Specification extends AbstractStructBase
{
    /**
     * The specificationType
     * Meta information extracted from the WSDL
     * - base: ns2:specificationTypeEnum
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $specificationType;
    /**
     * The SpecificationUom
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - nillable: true
     * @var string
     */
    public $SpecificationUom;
    /**
     * The measurementValue
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $measurementValue;
    /**
     * Constructor method for Specification
     * @uses Specification::setSpecificationType()
     * @uses Specification::setSpecificationUom()
     * @uses Specification::setMeasurementValue()
     * @param string $specificationType
     * @param string $specificationUom
     * @param string $measurementValue
     */
    public function __construct($specificationType = null, $specificationUom = null, $measurementValue = null)
    {
        $this
            ->setSpecificationType($specificationType)
            ->setSpecificationUom($specificationUom)
            ->setMeasurementValue($measurementValue);
    }
    /**
     * Get specificationType value
     * @return string|null
     */
    public function getSpecificationType()
    {
        return $this->specificationType;
    }
    /**
     * Set specificationType value
     * @param string $specificationType
     * @return \StructType\Specification
     */
    public function setSpecificationType($specificationType = null)
    {
        // validation for constraint: string
        if (!is_null($specificationType) && !is_string($specificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificationType, true), gettype($specificationType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($specificationType) && mb_strlen($specificationType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($specificationType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($specificationType) && mb_strlen($specificationType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($specificationType)), __LINE__);
        }
        $this->specificationType = $specificationType;
        return $this;
    }
    /**
     * Get SpecificationUom value
     * @return string|null
     */
    public function getSpecificationUom()
    {
        return $this->SpecificationUom;
    }
    /**
     * Set SpecificationUom value
     * @param string $specificationUom
     * @return \StructType\Specification
     */
    public function setSpecificationUom($specificationUom = null)
    {
        // validation for constraint: string
        if (!is_null($specificationUom) && !is_string($specificationUom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificationUom, true), gettype($specificationUom)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($specificationUom) && mb_strlen($specificationUom) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($specificationUom)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($specificationUom) && mb_strlen($specificationUom) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($specificationUom)), __LINE__);
        }
        $this->SpecificationUom = $specificationUom;
        return $this;
    }
    /**
     * Get measurementValue value
     * @return string|null
     */
    public function getMeasurementValue()
    {
        return $this->measurementValue;
    }
    /**
     * Set measurementValue value
     * @param string $measurementValue
     * @return \StructType\Specification
     */
    public function setMeasurementValue($measurementValue = null)
    {
        // validation for constraint: string
        if (!is_null($measurementValue) && !is_string($measurementValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measurementValue, true), gettype($measurementValue)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($measurementValue) && mb_strlen($measurementValue) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($measurementValue)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($measurementValue) && mb_strlen($measurementValue) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($measurementValue)), __LINE__);
        }
        $this->measurementValue = $measurementValue;
        return $this;
    }
}
