<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SizeApparel StructType
 * @subpackage Structs
 */
class SizeApparel extends AbstractStructBase
{
    /**
     * The apparelStyle
     * @var string
     */
    public $apparelStyle;
    /**
     * The labelSize
     * @var string
     */
    public $labelSize;
    /**
     * Constructor method for SizeApparel
     * @uses SizeApparel::setApparelStyle()
     * @uses SizeApparel::setLabelSize()
     * @param string $apparelStyle
     * @param string $labelSize
     */
    public function __construct($apparelStyle = null, $labelSize = null)
    {
        $this
            ->setApparelStyle($apparelStyle)
            ->setLabelSize($labelSize);
    }
    /**
     * Get apparelStyle value
     * @return string|null
     */
    public function getApparelStyle()
    {
        return $this->apparelStyle;
    }
    /**
     * Set apparelStyle value
     * @uses \EnumType\ApparelStyleEnum::valueIsValid()
     * @uses \EnumType\ApparelStyleEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $apparelStyle
     * @return \StructType\SizeApparel
     */
    public function setApparelStyle($apparelStyle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ApparelStyleEnum::valueIsValid($apparelStyle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ApparelStyleEnum', is_array($apparelStyle) ? implode(', ', $apparelStyle) : var_export($apparelStyle, true), implode(', ', \EnumType\ApparelStyleEnum::getValidValues())), __LINE__);
        }
        $this->apparelStyle = $apparelStyle;
        return $this;
    }
    /**
     * Get labelSize value
     * @return string|null
     */
    public function getLabelSize()
    {
        return $this->labelSize;
    }
    /**
     * Set labelSize value
     * @uses \EnumType\LabelSizeEnum::valueIsValid()
     * @uses \EnumType\LabelSizeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelSize
     * @return \StructType\SizeApparel
     */
    public function setLabelSize($labelSize = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LabelSizeEnum::valueIsValid($labelSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LabelSizeEnum', is_array($labelSize) ? implode(', ', $labelSize) : var_export($labelSize, true), implode(', ', \EnumType\LabelSizeEnum::getValidValues())), __LINE__);
        }
        $this->labelSize = $labelSize;
        return $this;
    }
}
