<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSellable StructType
 * @subpackage Structs
 */
class ProductSellable extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns3:productId
     * @var string
     */
    public $productId;
    /**
     * The partId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:partId
     * @var string
     */
    public $partId;
    /**
     * The culturePoint
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:culturePoint
     * @var string
     */
    public $culturePoint;
    /**
     * Constructor method for ProductSellable
     * @uses ProductSellable::setProductId()
     * @uses ProductSellable::setPartId()
     * @uses ProductSellable::setCulturePoint()
     * @param string $productId
     * @param string $partId
     * @param string $culturePoint
     */
    public function __construct($productId = null, $partId = null, $culturePoint = null)
    {
        $this
            ->setProductId($productId)
            ->setPartId($partId)
            ->setCulturePoint($culturePoint);
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\ProductSellable
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($productId) && mb_strlen($productId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($productId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productId) && mb_strlen($productId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get partId value
     * @return string|null
     */
    public function getPartId()
    {
        return $this->partId;
    }
    /**
     * Set partId value
     * @param string $partId
     * @return \StructType\ProductSellable
     */
    public function setPartId($partId = null)
    {
        // validation for constraint: string
        if (!is_null($partId) && !is_string($partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partId, true), gettype($partId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($partId) && mb_strlen($partId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($partId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partId) && mb_strlen($partId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partId)), __LINE__);
        }
        $this->partId = $partId;
        return $this;
    }
    /**
     * Get culturePoint value
     * @return string|null
     */
    public function getCulturePoint()
    {
        return $this->culturePoint;
    }
    /**
     * Set culturePoint value
     * @param string $culturePoint
     * @return \StructType\ProductSellable
     */
    public function setCulturePoint($culturePoint = null)
    {
        // validation for constraint: string
        if (!is_null($culturePoint) && !is_string($culturePoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($culturePoint, true), gettype($culturePoint)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($culturePoint) && mb_strlen($culturePoint) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($culturePoint)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($culturePoint) && mb_strlen($culturePoint) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($culturePoint)), __LINE__);
        }
        $this->culturePoint = $culturePoint;
        return $this;
    }
}
