<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductPriceGroup StructType
 * @subpackage Structs
 */
class ProductPriceGroup extends AbstractStructBase
{
    /**
     * The ProductPriceArray
     * @var \ArrayType\ProductPriceArray
     */
    public $ProductPriceArray;
    /**
     * The groupName
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns2:groupName
     * @var string
     */
    public $groupName;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - ref: ns2:currency
     * @var string
     */
    public $currency;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 2048
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns2:description
     * @var string
     */
    public $description;
    /**
     * Constructor method for ProductPriceGroup
     * @uses ProductPriceGroup::setProductPriceArray()
     * @uses ProductPriceGroup::setGroupName()
     * @uses ProductPriceGroup::setCurrency()
     * @uses ProductPriceGroup::setDescription()
     * @param \ArrayType\ProductPriceArray $productPriceArray
     * @param string $groupName
     * @param string $currency
     * @param string $description
     */
    public function __construct(\ArrayType\ProductPriceArray $productPriceArray = null, $groupName = null, $currency = null, $description = null)
    {
        $this
            ->setProductPriceArray($productPriceArray)
            ->setGroupName($groupName)
            ->setCurrency($currency)
            ->setDescription($description);
    }
    /**
     * Get ProductPriceArray value
     * @return \ArrayType\ProductPriceArray|null
     */
    public function getProductPriceArray()
    {
        return $this->ProductPriceArray;
    }
    /**
     * Set ProductPriceArray value
     * @param \ArrayType\ProductPriceArray $productPriceArray
     * @return \StructType\ProductPriceGroup
     */
    public function setProductPriceArray(\ArrayType\ProductPriceArray $productPriceArray = null)
    {
        $this->ProductPriceArray = $productPriceArray;
        return $this;
    }
    /**
     * Get groupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * Set groupName value
     * @param string $groupName
     * @return \StructType\ProductPriceGroup
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($groupName) && mb_strlen($groupName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($groupName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($groupName) && mb_strlen($groupName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($groupName)), __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @uses \EnumType\CurrencyCodeType::valueIsValid()
     * @uses \EnumType\CurrencyCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\ProductPriceGroup
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyCodeType::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyCodeType', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\CurrencyCodeType::getValidValues())), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ProductPriceGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($description) && mb_strlen($description) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($description) && mb_strlen($description) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
