<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductMarketingPoint StructType
 * @subpackage Structs
 */
class ProductMarketingPoint extends AbstractStructBase
{
    /**
     * The pointType
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $pointType;
    /**
     * The pointCopy
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 1024
     * - minLength: 1
     * @var string
     */
    public $pointCopy;
    /**
     * Constructor method for ProductMarketingPoint
     * @uses ProductMarketingPoint::setPointType()
     * @uses ProductMarketingPoint::setPointCopy()
     * @param string $pointType
     * @param string $pointCopy
     */
    public function __construct($pointType = null, $pointCopy = null)
    {
        $this
            ->setPointType($pointType)
            ->setPointCopy($pointCopy);
    }
    /**
     * Get pointType value
     * @return string|null
     */
    public function getPointType()
    {
        return $this->pointType;
    }
    /**
     * Set pointType value
     * @param string $pointType
     * @return \StructType\ProductMarketingPoint
     */
    public function setPointType($pointType = null)
    {
        // validation for constraint: string
        if (!is_null($pointType) && !is_string($pointType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointType, true), gettype($pointType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($pointType) && mb_strlen($pointType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($pointType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pointType) && mb_strlen($pointType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pointType)), __LINE__);
        }
        $this->pointType = $pointType;
        return $this;
    }
    /**
     * Get pointCopy value
     * @return string|null
     */
    public function getPointCopy()
    {
        return $this->pointCopy;
    }
    /**
     * Set pointCopy value
     * @param string $pointCopy
     * @return \StructType\ProductMarketingPoint
     */
    public function setPointCopy($pointCopy = null)
    {
        // validation for constraint: string
        if (!is_null($pointCopy) && !is_string($pointCopy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointCopy, true), gettype($pointCopy)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($pointCopy) && mb_strlen($pointCopy) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($pointCopy)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pointCopy) && mb_strlen($pointCopy) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pointCopy)), __LINE__);
        }
        $this->pointCopy = $pointCopy;
        return $this;
    }
}
