<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductKeyword StructType
 * @subpackage Structs
 */
class ProductKeyword extends AbstractStructBase
{
    /**
     * The keyword
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 16384
     * - minLength: 1
     * @var string
     */
    public $keyword;
    /**
     * Constructor method for ProductKeyword
     * @uses ProductKeyword::setKeyword()
     * @param string $keyword
     */
    public function __construct($keyword = null)
    {
        $this
            ->setKeyword($keyword);
    }
    /**
     * Get keyword value
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->keyword;
    }
    /**
     * Set keyword value
     * @param string $keyword
     * @return \StructType\ProductKeyword
     */
    public function setKeyword($keyword = null)
    {
        // validation for constraint: string
        if (!is_null($keyword) && !is_string($keyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyword, true), gettype($keyword)), __LINE__);
        }
        // validation for constraint: maxLength(16384)
        if (!is_null($keyword) && mb_strlen($keyword) > 16384) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16384', mb_strlen($keyword)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($keyword) && mb_strlen($keyword) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($keyword)), __LINE__);
        }
        $this->keyword = $keyword;
        return $this;
    }
}
