<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDateModified StructType
 * @subpackage Structs
 */
class ProductDateModified extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns3:productId
     * @var string
     */
    public $productId;
    /**
     * The partId
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:partId
     * @var string
     */
    public $partId;
    /**
     * Constructor method for ProductDateModified
     * @uses ProductDateModified::setProductId()
     * @uses ProductDateModified::setPartId()
     * @param string $productId
     * @param string $partId
     */
    public function __construct($productId = null, $partId = null)
    {
        $this
            ->setProductId($productId)
            ->setPartId($partId);
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\ProductDateModified
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($productId) && mb_strlen($productId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($productId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productId) && mb_strlen($productId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get partId value
     * @return string|null
     */
    public function getPartId()
    {
        return $this->partId;
    }
    /**
     * Set partId value
     * @param string $partId
     * @return \StructType\ProductDateModified
     */
    public function setPartId($partId = null)
    {
        // validation for constraint: string
        if (!is_null($partId) && !is_string($partId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partId, true), gettype($partId)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($partId) && mb_strlen($partId) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($partId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partId) && mb_strlen($partId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partId)), __LINE__);
        }
        $this->partId = $partId;
        return $this;
    }
}
